---
title: Principal Component Analysis
localeTitle: Анализ главных компонентов
---
## Анализ основных компонентов (PCA)

### Что это?

Анализ основных компонентов (PCA) - это алгоритм, используемый для машинного обучения для уменьшения размеров набора данных. Вы можете уменьшить набор данных, содержащий сотни различных функций, для нового набора данных, содержащего только два.

Например, представьте, что вы хотите измерить способность пилота. В этом есть много разных факторов. Двумя соответствующими характеристиками, которые следует учитывать, могут быть навыки пилота и удовольствие от пилота. Это будет двумерный набор данных, поскольку он содержит две функции. PCA может свести эти функции к одному, сплавляя их вместе. Вы можете назвать эту новую функцию «пилот-способностью». Эта новая функция дает вам более простой показатель для измерения способности пилота.

Если вы примените пилотное мастерство против удовольствия пилота, вы можете получить что-то вроде этого:

![Использование навыков пилота и пилота](https://github.com/DHDaniel/guides/blob/master/src/pages/machine-learning/principal-component-analysis/plot-skill-vs-enjoyment.png?raw=true)

Интуитивно, что делает PCA, он находит лучшую прямую линию (или плоскость, в ситуациях более высокого порядка), на которой можно спроецировать эти две функции. Проецирование выполняется путем вычерчивания перпендикулярной линии между точкой и линией. Вы можете увидеть иллюстрацию этого ниже:

![Проекция на линию](https://github.com/DHDaniel/guides/blob/master/src/pages/machine-learning/principal-component-analysis/projection.png?raw=true)

Вы можете думать о PCA как о поиске лучшей линии для набора данных, чтобы информация о каждой точке лучше сохранялась. Он делает это, сводя к минимуму сумму квадратов ошибок проекции каждой точки. Ошибка проектирования - это длина перпендикулярных линий, проецирующих каждую точку на линию. Минимизируя их, вы гарантируете, что выбранная прямая линия является наилучшей комбинацией этих двух функций.

Ниже приведены примеры хорошей линии для проецирования данных и плохой. Полученные проекции хорошей линии более характерны для исходных данных и имеют меньшие ошибки. Происходящие проекции плохой линии явно хуже, а ошибки проектирования намного больше.

![Хорошая против плохой проекции точек](https://github.com/DHDaniel/guides/blob/master/src/pages/machine-learning/principal-component-analysis/good-vs-bad-projection.png?raw=true)

**Важно** : Стоит отметить, что PCA отличается от [линейной регрессии](https://en.wikipedia.org/wiki/Linear_regression) . Цели оптимизации (что они сводят к минимуму) различны.

Если вы запустите PCA в наборе данных пилот-сигнала, вы можете получить новую функцию «aptitude», которая выглядит примерно так:

![Преобразование пилотного набора данных с использованием PCA](https://github.com/DHDaniel/guides/blob/master/src/pages/machine-learning/principal-component-analysis/PCA-on-dataset.png?raw=true)

Математика позади PCA несколько сложна, но вам не обязательно быть экспертом в этом, чтобы иметь возможность использовать ее. Несмотря на то, что за ним много линейной алгебры, использование этого относительно легко. Это связано с тем, что существует множество библиотек кодов с готовыми реализациями PCA. Несколько примеров включают:

*   [Реализация JavaScript PCA](https://github.com/mljs/pca) .
*   [Python scikit-learn](http://scikit-learn.org/stable/modules/generated/sklearn.decomposition.PCA.html) .
*   [Реализация MATLAB](https://www.mathworks.com/help/stats/pca.html) .

### Зачем использовать его?

Существует много причин использовать алгоритм PCA. Очень важным является визуализация данных. Легко визуализировать данные 1-D, 2-D и даже 3-D, но кроме того, становится трудно. В процессе машинного обучения часто очень полезно визуализировать данные, прежде чем приступать к работе над ним. Но высокоразмерный набор данных очень трудно визуализировать. Используя PCA, стомерный набор данных может быть сведен к двумерному.

Это особенно полезно в реальных ситуациях, где наборы данных часто являются высокоразмерными. Например, вы можете объединить показатели экономической эффективности, такие как GDP, HDI и т. Д., В одну функцию. Это позволяет лучше сравнивать страны, а также позволяет визуализировать данные с использованием графика.

Еще одна причина использования алгоритма PCA заключается в том, чтобы сделать ваш набор данных меньше. Для проблем, связанных со многими тысячами функций (например, обработка изображений), алгоритмы машинного обучения могут занять много времени. Уменьшая количество функций, вы можете улучшить скорость этих алгоритмов, не жертвуя точностью. Вы также можете сэкономить много места на диске, особенно если вы работаете с огромными наборами данных.

### Ограничения

Поскольку вы в основном упрощаете набор данных при запуске PCA, некоторые детали могут быть потеряны в процессе. Это особенно относится к точкам данных, которые очень распространены и не имеют очень сильной корреляции.

#### Предлагаемое чтение:

*   https://www.reddit.com/r/datascience/comments/668pp1
*   https://en.wikipedia.org/wiki/Перигинальный _компонентный_ анализ
*   http://www.cs.otago.ac.nz/cosc453/student _учебники / основные_ компоненты.pdf
*   http://setosa.io/ev/principal-component-analysis/ (Интерактивный)

Википедия говорит: «Анализ основных компонентов (PCA) - это статистическая процедура, которая использует ортогональное преобразование для преобразования набора наблюдений возможных коррелированных переменных в набор значений линейно некоррелированных переменных, называемых главными компонентами (или иногда основными модальностями вариации) «.

Анализ основных компонентов (PCA) представляет собой статистический метод, используемый для изучения взаимосвязей между набором переменных, чтобы идентифицировать основную структуру этих переменных. PCA обычно уменьшает количество функций от N-мерного до k-мерного, где k <N

PCA имеет следующие приложения: 1) Сжатие: Увеличьте вычислительную скорость, а также уменьшите пространство для хранения 2) Визуализация: PCA может уменьшить данные до двух или трехмерных данных для целей визуализации