---
title: Correlation Does not Imply Causation
localeTitle: Корреляция не означает причинения
---
## Корреляция не означает причинения

Многие сайты, связанные с фитнесом и здоровьем, часто пропускают этот момент в отношении исследований, которые, как правило, происходят в этих областях. Они сообщают о научных исследованиях как о причинах, отличных от того, что это на самом деле, Корреляции. Напр. исследователи обнаружили, что ранние восходящие потоки имеют более низкий ИМТ и, как оказалось, менее ожирением. Эта корреляция может быть искажена, поскольку «Пробуждение рано может уменьшить шансы ожирения». Мы не знаем, что просто пробуждение рано «вызвало» результат - более низкое ожирение. Мы нашли здесь Корреляцию.

Неофициальное определение Корреляции происходит так же, как и при событии A, событие B также имеет тенденцию происходить и наоборот. Или люди, которые рано встают, склонны к нижнему концу весового спектра. Оба события, как правило, происходят вместе. Но не обязательно, чтобы одно событие вызвало другое.

Причинность означает, что событие A «вызвало» или привело к возникновению события B. Например, если бы я стоял на солнце, я бы загорелся. Здесь второе событие происходит из-за первого.

В статистике много разговоров о **коррелированных переменных** . Корреляция - это взаимосвязь между двумя переменными. **Причиной** является отношение, в котором изменение одной переменной **отвечает за** изменение другой переменной. Это также известно как **причинно-следственная связь** .

При наличии причинно-следственной связи между двумя переменными существует также корреляция между ними. Но корреляция между двумя переменными не предполагает причинно-следственной связи между ними. Это [логическая ошибка](https://en.wikipedia.org/wiki/Formal_fallacy) .

Это связано с тем, что корреляция между двумя переменными может быть объяснена многими причинами:

*   Одна переменная влияет на другую. Это _было_ бы причинно-следственной связью. Например, существует корреляция между заработной платой домохозяйства и количеством принадлежащих ему автомобилей.
*   Обе переменные влияют друг на друга. Это _будет_ двухсторонняя причинно-следственная связь. Например, соотношение между уровнем образования и богатством человека.
*   Существует еще одна переменная, которая влияет на обе проверенные переменные. Это _не_ было бы причинно-следственной связью. Например, количество принадлежащих автомобилей и размер дома могут быть скоррелированы, но на эти две переменные влияет другая переменная: зарплата. Увеличение количества принадлежащих автомобилей не влияет на размер дома.
*   Корреляция может быть случайной случайностью. Это _не_ было бы причинно-следственной связью. Это объяснение предыдущего примера потребления маргаринов и коэффициента развода в штате Мэн.

Для машинного обучения достаточно корреляции для создания прогностической модели. Однако только потому, что корреляция двух переменных не означает, что одна переменная влияет на другую. Другими словами, хотя машинное обучение может помочь найти связь между двумя переменными, это не обязательно поможет найти причину отношений.