---
title: 2 by 2 Determinants
localeTitle: 2 на 2 Определители
---
## 2 на 2 Определители

В линейной алгебре детерминант матрицы два на две является полезной величиной. Более того, она используется для вычисления площади данных четырехсторонних (только выпуклых многоугольников) и также является легким представлением четырехсторонних (только выпуклых многоугольников) для хранения в компьютерах как массивы. Ученые, инженеры и математики используют детерминанты во многих повседневных приложениях, включая графическую и графическую обработку.

Вычисление определителя квадратной матрицы два на две является простым и является основой [формулы Лапласа,](https://en.wikipedia.org/wiki/Laplace_expansion) используемой для вычисления детерминант для больших квадратных матриц.

Учитывая матрицу A, определитель A (записанный как | A |) задается следующим уравнением:

## Свойства (2x2) детерминант

Строки и векторы матрицы 2 на 2 могут быть связаны с точками на картезиальной плоскости, так что каждая строка образует 2D-вектор. Эти два вектора образуют параллелограмм, как показано на рисунке ниже. Доказательство: Пусть векторы представляют собой M (a, b), N (c, d), исходящие из начала координат в двумерной плоскости с углом ( _theta_ > 0) между ними (голова одного вектора, касающегося хвоста другого вектора). Но здесь это не имеет значения, потому что sin (theta) = sin (2 (pi) -theta). Тогда другая точка P (a + c, b + d). Площадь параллелограмма перпендикулярна расстоянию от одного точка N (c, d) на базовый вектор, M (a, b), умноженный на длину базового вектора, | M (a, b) |. Следовательно, параллелограмм состоит из двух треугольников, площадь которых в два раза меньше треугольника. Пусть перпендикулярное расстояние h h = | N (c, d) | \* sin ( _theta_ (угол между двумя векторами)) б = | М (а, б) | Площадь = h \* b

Абсолютная величина определителя равна площади параллелограмма.

![](https://upload.wikimedia.org/wikipedia/commons/thumb/a/ad/Area_parallellogram_as_determinant.svg/1044px-Area_parallellogram_as_determinant.svg.png) [Вот](https://i.stack.imgur.com/gCaz3.png) интересное визуальное доказательство этого свойства.

Примечание. Если детерминант равен нулю, то в системе нет решений (пересечений) (так как прямые параллельны).

#### Дополнительная информация:

*   [Определитель матрицы](https://github.com/freeCodeCamp/guides/blob/master/src/pages/mathematics/determinant-of-a-matrix/index.md "Определитель матрицы")
*   [Википедия: 2x2 Определитель](https://en.wikipedia.org/wiki/Determinant#2_.C3.97_2_matrices)

![IMG](https://ncalculators.com/images/formulas/2x2-matrix-determinant.jpg)