---
title: Accuracy and Precision
localeTitle: Тщательность и точность
---
## Тщательность и точность

Точность и точность часто используются взаимозаменяемо, но означают разные вещи.

### Точность - это близость к истинному значению

В науке и технике точность измерения - это степень близости или истинности этого измерения до истинного значения измеряемой величины.

Например, линейка, которая измеряет известную длину 1 метр как 1 метр, будет иметь высокую точность; линейка, которая измеряет то же расстояние, что и 0,8 метра, будет иметь низкую точность. Другим примером может быть, если вы пытаетесь измерить pi, точность будет определяться тем, насколько близки ваши измерения к известному значению pi: 3.141592 ...

### Точность заключается в изменчивости повторных измерений

Точность измерения - это повторяемость этого измерения и выражает изменчивость внутри него. Другими словами, точность может приближаться к тем или иным измерениям каждый раз.

Например, если упомянутая выше линейка, измеряющая 1 метр на 0,8 метра, измеряет расстояние 0,80 м, 0,79 м, 0,80 м, 0,81 м и 0,80 м над последовательными мерами, линейка будет довольно точной (измерения имеют низкую изменчивость) , будучи неточным. Кроме того, используя пример pi, как указано выше, если ваши измерения постоянно получают 3.12, то они точны, но не точны.

### Точность и точность независимы друг от друга

Точность измерения не зависит от точности измерения. Точно так же точность измерения не зависит от его точности. Это означает, что измерения могут быть точными и с низкой точностью, точностью и низкой точностью, точными и точными, а также неточными и неточными.

### Баскетбольная аналогия

Хорошая аналогия для понимания точности и точности заключается в том, чтобы представить себе баскетболист, снимающий корзины. Если игрок стреляет с точностью, его цель всегда будет принимать мяч близко или в корзину. Если игрок стреляет с точностью, его цель всегда будет принимать мяч в том же месте, которое может или не может быть близко к корзине. Хороший игрок будет точным и точным, стреляя в мяч одинаково каждый раз и каждый раз делая его в корзине.

![](http://cdn.antarcticglaciers.org/wp-content/uploads/2013/11/precision_accuracy.png)

#### Дополнительная информация:

*   [Точность и точность статистических данных](http://www.statisticshowto.com/accuracy-and-precision/)
*   [Точность и точность от веб-сайта г-на Эванса](https://sites.google.com/a/apaches.k12.in.us/mr-evans-science-website/accuracy-vs-precision)
*   [Точность и точность из Википедии](https://en.wikipedia.org/wiki/Accuracy_and_precision)