---
title: All Factors of a Number
localeTitle: Все факторы числа
---
## Все факторы числа

Вы можете думать о факторах как о числах, которые вы умножаете, чтобы получить другое число.

![](https://upload.wikimedia.org/wikipedia/commons/e/e8/Factor_Tree_of_42.png)

В этом случае 2, 3, 6 и 7 - все числа, которые вы можете умножить, чтобы получить 42. Таким образом, все они являются факторами 42. Однако они не все факторы 42. Чтобы найти все факторы, мы можем использовать алгоритм или шаг за шагом по процессу ниже.

Начните с 1.

1 \* 42 = 42

1 | ... | 42 --- | --- | ---

Попробуйте 2.

2 \* 21 = 42

1 | 2 | ... | 21 | 42 --- | --- | --- | --- | ---

Попробуйте 3.

3 \* 14 = 42

1 | 2 | 3 | ... | 14 | 21 | 42 --- | --- | --- | --- | --- | --- | ---

Попробуйте 4.

Никакое целое число не может быть умножено на 4, чтобы получить 42, поэтому мы пропустим его.

Попробуйте 5.

Никакое целое число не может быть умножено на 5, чтобы получить 42, поэтому мы пропустим его.

Попробуйте 6.

6 \* 7 = 42

1 | 2 | 3 | 6 | ... | 7 | 14 | 21 | 42 --- | --- | --- | --- | --- | --- | --- | --- | ---

Поскольку целых чисел от 6 до 7 нет, все положительные факторы обнаружены. Все цифры, приведенные выше, могут быть перевернуты, и они останутся факторами 42. В заключение все факторы 42 ниже.

1 | 2 | 3 | 6 | 7 | 14 | 21 | 42 | -1 | -2 | -3 | -6 | -7 | -14 | -21 | -42 --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | ---

## Подтвердить количество факторов правильно

Мы можем быстро подтвердить, что мы определили все положительные факторы со следующими шагами:

1.  Возьмем основную факторизацию (предоставленную выше)

2 1 \* 3 1 \* 7 \* 1

2.  Добавьте один к каждому из показателей:

Показатель 2: 1 + 1 = 2 Показатель 3: 1 + 1 = 2 Показатель 7: 1 + 1 = 2

3.  Несколько из приведенных выше цифр:

2 \* 2 \* 2 = 8

4.  Подтвердите, что у 42 есть 8 факторов:

1 | 2 | 3 | 6 | ... | 7 | 14 | 21 | 42 --- | --- | --- | --- | --- | --- | --- | --- | ---