---
title: Combinations and Permutations
localeTitle: Комбинации и перестановки
---
## Комбинации и перестановки

Допустим, у вас 9 человек, которые участвуют в тройке турниров по гольфу. Сколько различных возможностей есть в первой тройке турниров? Ну, если мы сначала выбираем первое место, у нас есть 9 человек на выбор. После этого у нас было бы 8 вариантов на второе место, а 7 на третье место. Чтобы вычислить общее количество, мы просто должны умножить их вместе:

9x8x7 = 505

Это пример перестановки. Перестановка - это количество различных упорядоченных возможностей, которые могут возникать в данной ситуации. Перестановка может быть с или без повторения, так же как и комбинация. Если мы скажем, что существует перестановка для n вещей с r возможностями, формулы будут:

\##### **С повторением:** п ^ г

\##### **Без повторения:** п! / (№)!

Вернувшись к проблеме наверху, что, если они сидят в трех одинаковых стульях вместо того, чтобы иметь рейтинг? Это пример комбинации. В сочетании, порядок не имеет значения. Поэтому каждая перестановка одной и той же комбинации должна быть устранена. Это создает еще две формулы:

\##### **С повторением:** (Г + п-1)! / (Г! (П-1)!)

\##### **Без повторения:** п! / (г! (пг)!)

### источники

«Комбинации и перестановки». Math is Fun, www.mathsisfun.com/combinatorics/combinations-permutations.html.

[Помогите нашему сообществу расширить эту статью](https://github.com/freecodecamp/guides/tree/master/src/pages/mathematics/combinations-and-permutations/index.md) .

[Это руководство по быстрому стилю поможет вам принять ваш запрос на тягу](https://github.com/freecodecamp/guides/blob/master/README.md) .

#### Дополнительная информация: