---
title: Converting from Decimal to Binary
localeTitle: Преобразование из десятичного в двоичный
---
## Преобразование из десятичного в двоичный

Вы можете использовать остатки для преобразования десятичных чисел в двоичные числа.

### Общий метод

1) Разделите исходное десятичное число на 2 и запишите коэффициент и остаток. 2) Повторите первый шаг, заменив исходное десятичное число на последнее частное, которое вы нашли, до тех пор, пока не получите коэффициент, равный 0. 3) Возьмите последний оставшийся остаток, который вы записали, чтобы быть вашим MSB (самый старший бит), и первым остатком, который вы записали, как ваш младший бит (младший бит). Запишите остатки в обратном порядке от того, как вы их создали.

### Примеры

Преобразование десятичного числа 30 в двоичное.
```
30 / 2 = 15 r 0 
 15 / 2 = 7 r 1 
 7 / 2 = 3 r 1 
 3 / 2 = 1 r 1 
 1 / 2 = 0 r 1 
 
 Writing out the remainders bottom to top gives you the bit pattern: 
 
 11110 
 
 Checking your answer by converting the binary number back to decimal: 
 
 (1*2^4)+(1*2^3)+(1*2^2)+(1*2^1)+(0*2^0) = 30 
 
 So your answer is correct. 
```

Преобразование десятичного числа 116 в двоичное.
```
116 / 2 = 58 r 0 
 58 / 2 = 29 r 0 
 29 / 2 = 14 r 1 
 14 / 2 = 7 r 0 
 7 / 2 = 3 r 1 
 3 / 2 = 1 r 1 
 1 / 2 = 0 r 1 
 
 Writing out the remainders bottom to top gives you the bit pattern: 
 
 1110100 
 
 Checking your answer by converting the binary number back to decimal: 
 
 (1*2^6)+(1*2^5)+(1*2^4)+(0*2^3)+(1*2^2)+(0*2^1)+(0*2^0) = 116 
 
 So your answer is correct. 

```