---
title: Converting Units Centimeters to Meters
localeTitle: Преобразование единиц сантиметров в метры
---
## Преобразование единиц сантиметров в метры

Centi- (символ c) является единичным префиксом в метрической системе, обозначающим коэффициент сотой

Значение Centimenter составляет одну сотую метра. x см = xm / 100

Примеры 1 см = 1 м / 100 = 0,01 м 10 см = 10 м / 100 = 0,1 м 1,2 см = 1,2 м / 100 = 0,012 м

По определению, _один_ сантиметр - это _одна метра_ метра

В следующей формуле единицы обозначаются скобками \[\] вокруг них
```
[cm] / 100 = [m] 
```

Если вы введете значение, которое у вас есть, скажем, 50 сантиметров, оно будет рассчитано следующим образом:
```
50[cm] / 100 = 0.5[m] 
```

Результат вычисления возвращает значение 0,5 метра, количество метров - 50 сантиметров.

### Примеры

1.  1 см = 0,01 м (1/100)
2.  25 см = 0,25 м (25/100)
3.  200 см = 2 м (200/100)

### кодирование

```js
function convertCentimeterToMeter (cm) { 
  return ( cm / 100 ); 
 } 
 
 // Set some example measurements 
 var lengthInCm = 300; 
 var lengthInM; 
 
 lengthInM = convertCentimeterToMeter(lengthInCm); // 3 
```

### Дополнительная информация:

*   [Преобразовать cm в m](https://www.convertunits.com/from/cm/to/m)
*   [Статья в Википедии о Centi](https://en.wikipedia.org/wiki/Centi-)