---
title: Pigeonhole Principle
localeTitle: Принцип Pigeonhole
---
## Принцип Pigeonhole

Принцип Pigeonhole - это математическая формализация логического и интуитивного наблюдения. Это наблюдение лучше всего понять на примере.

### пример

Есть пять ящиков и шесть мячей. Каждый из шести шаров помещается в один из пяти ящиков. _Должна_ быть хотя бы одна коробка с не менее чем двумя мячами. Если пять мячей помещены в пять ящиков, так что в коробке нет двух шариков, то независимо от того, в какую коробку помещается шестой шар, у этого ящика будет более одного шара.

### Обобщение

Это наблюдение можно обобщить для N боксов и М шаров. Если есть N полей и М шаров, а M> N, то по крайней мере один ящик должен содержать несколько шаров.

Обратите внимание, что Принцип Pigeonhole не говорит нам ничего о том, в какой коробке есть более одного шара или сколько шаров у любого из коробок. Принцип Pigeonhole утверждает только существование коробки с несколькими шарами.

### Использование в информатике

Принцип Pigeonhole часто проявляется в информатике. Например, алгоритм хеширования SHA256 принимает ввод любого размера (например, строки) и выводит 256-битное значение. Поскольку выход алгоритма хэширования SHA256 всегда равен 256 бит, существует 2 ^ 256 возможных хэшей. Хотя это очень большое число, существует бесконечное количество возможных входов. Используя вышеприведенное обобщение, мы можем сказать, что наши N = 2 ^ 256 и наша M = бесконечность. Поскольку бесконечность больше, чем 2 ^ 256 (M> N), то по принципу Голубого отверстия по крайней мере одна из этих хешей должна иметь два разных входа, хэш которых имеет одинаковое значение. Ученые компьютеров называют два разных входа, совместно использующих хэш-столкновение.

### Использование в общих задачах подсчета

Мы можем использовать принцип Pigeonhole, чтобы доказать еще некоторые эзотерические вещи. Общим примером является проблема подсчета волос. Человеческая голова имеет от 0 до 150 000 волос. Чтобы оставаться в безопасности, предположим, что у человека может быть до одного миллиона волос на голове. В Париже во Франции проживает около 2,2 миллиона человек. Если мы сортируем всех в Париже на ящики, исходя из того, сколько волос у них на голове, тогда мы можем использовать наше обобщение выше, чтобы сказать N = 1000000 (количество ящиков, одна коробка для каждого возможного подсчета волос) и M = 2200000 ( население Парижа, Франция). Так как M> N, по принципу Голубого отверстия можно с уверенностью констатировать, что по крайней мере два человека в Париже должны иметь одинаковое количество волос на голове.

#### Дополнительная информация:

*   [Википедия - Принцип Pigeonhole](https://en.wikipedia.org/wiki/Pigeonhole_principle)
*   [Более забавные примеры принципа Pigeonhole](https://mindyourdecisions.com/blog/2008/11/25/16-fun-applications-of-the-pigeonhole-principle/)