---
title: Definition of Mode
localeTitle: Определение режима
---
## Определение режима

В статистике термин _режим_ относится к значению или значениям в наборе данных, который появляется наиболее часто. Потому что это происходит чаще всего в наборе данных, _режим_ наиболее вероятное значение , чтобы быть случайной выборки.

Режим набора чисел указывает значение, которое наиболее часто встречается в наборе. При распределении данных режим можно описать как максимум либо функции массы вероятности, если данные дискретны, либо функция распределения вероятности, если данные непрерывны.

#### Набор данных может иметь один или несколько режимов

Рассмотрим набор данных 14, 16, 21, 33, 37, 16, 39, 33. Здесь 16 и 33 каждый происходит дважды. Все остальные числа происходят только один раз. Таким образом, 16 и 33 имеют максимальную частоту встречаемости, которая равна 2. Следовательно, для заданного набора данных существует два режима, т. Е. 16 и 33. Набор чисел, в котором есть два числа, которые наиболее часто встречаются, можно описать как бимодальные , а любое число, большее двух, называется мультимодальным.

#### Также возможно иметь набор данных без режима

Рассмотрим набор данных 10, 15, 24, 34, 38, 16, 41. Здесь все числа встречаются только один раз. Таким образом, ни один номер не имеет максимальной частоты появления. Следовательно, для данного набора данных нет режима.

## Правила для поиска режима набора данных

*   Изучите все номера набора данных и найдите, если одно или несколько номеров встречаются более одного раза.
*   Число с максимальной частотой появления - это режим.
*   Если более одного номера имеют максимальную частоту, то для набора данных существует более одного режима.
*   Если все номера набора данных происходят только один раз, то для набора данных нет режима.

#### пример

Режим (1, 2, 3, 2, 4, 5) равен **2** :

_Чтобы найти режим, вы должны подсчитать количество вхождений каждого значения в наборе данных. Значение 2 появляется дважды в наборе данных, а остальные значения появляются только один раз, что делает 2-й режим._

Режим (7, 7, 8, 8, 9) равен 7 **и** 8:

_Если есть привязка к значениям, которые наиболее часто встречаются в наборе данных, каждый из значений с этой частотой является режимом._

#### Среднее и среднее

Режим часто путают со [средним значением](https://guide.freecodecamp.org/mathematics/definition-of-mean) , среднее значение в наборе данных [медиана](https://en.wikipedia.org/wiki/Median) , значение в середине набора данных.

#### Дополнительная информация:

[Википедия - Режим](https://en.wikipedia.org/wiki/Mode_(statistics))

[Определение режима](https://www.tutorialspoint.com/mean_median_and_mode/mode_of_data_set.htm)