---
title: Definition of Real Number
localeTitle: Определение реального номера
---
## Определение реального номера

> Реальные числа можно рассматривать как точки бесконечно длинной линии.

Реальные числа включают в себя все рациональные числа, такие как _1/2_ , _0_ , _103.644_ и _271/272_ , а также все иррациональные числа, такие как _pi_ , квадратный корень из 2 и _e_ . Обратите внимание, что «Комплексные числа», числа, которые включают ненулевую мнимую величину, не включены.

Таким образом, любое число с десятичным представлением, даже если это представление бесконечно, является реальным, _например, 1.234567891 ..._ Отметим, что квадратный корень отрицательного числа не имеет десятичного представления, поэтому квадратный корень любого отрицательного числа не является реальным. Так получилось, что квадратный корень из _\-1 как_ раз и есть определение « _i_ », длина единицы в системе мнимых чисел. Ниже приведено краткое описание того, как можно получить и определить реальные числа, но это, безусловно, не является формальным доказательством.

Рассмотрим понятие _1_ , одного объекта, единицы. Пусть множество натуральных чисел **_N_** описывается правилами:

*   _1_ - натуральное число
*   Каждое натуральное число имеет ровно один преемник (число больше самого себя).
*   _1_ не имеет преемника.

Они определяют понятие подсчета, а с еще несколькими правилами, выходящими за рамки этой статьи, могут быть определены такие правила, как добавление и закрытие в этом новом наборе чисел, **_N._** Этот набор, наряду с понятием _0_ , создает набор целых чисел. Когда понятие «отрицательное число» добавляется к этому набору «целых чисел», образуются целые числа. Отрицательным числом является число b такое, что _a + b = 0_ , где _a_ находится в **_N_** (так что _a не_ является ни 0, ни отрицательным). Назовем это объединение _0_ , **_N_** и отрицательными числами **_Z_** или _целыми числами_ .

Мы определяем умножение под операцией « _\*_ » таким, что если _a_ и _b_ находятся в **_Z_** , то _a \* b = c,_ если _c = a + ... + a_ , _b_ раз. Таким образом, умножение целых чисел - это просто сумма. Обратите внимание, что по этому определению добавление может быть сделано отрицательным числом раз. Теперь мы используем умножение для определения деления, которое позволит нам определить рациональные числа.

Определим деление под операцией « _/_ » так, чтобы, если _a_ и _b_ находятся в **_Z_** , то _c = a / b_ тогда и только тогда, когда существует _a = b \* c + r_ , где _r = 0_ , а _c_ - в **_Z._** Но что, если _a = b \* c + r_ , где _0 <r <b_ ? Тогда _b_ не равномерно делит _a_ , и это уравнение неразрешимо в нашей системе чисел **_Z._** Но что, если бы это уравнение было разрешимо, и _c_ можно было бы выразить как _отношение_ , такое, что _c = a / b,_ несмотря на то, что _b_ не равномерно делит _a_ ? Это намекает на набор чисел, известных как _рациональные числа_ **_Q_** , члены которых могут быть выражены как _a / b_ , где _a_ и _b_ находятся в **_Z._** Заметим, что все десятичные представления чисел из **_Q_** либо конечны, либо повторяются.

Некоторые числа не могут быть описаны как отношение целых чисел, например, квадратный корень из 2, _pi_ и _e_ . Все не повторяющиеся десятичные числа без конечной длины являются иррациональными. Это свойство справедливо для всех рациональных базисов чисел. Посредством «заполнения пробелов» между рациональными числами этими иррациональными числами можно построить вещественные числа **_R._**

Обратите внимание, что компьютеры фактически не работают с реальными числами, а компьютеры работают с двоичными целыми числами, которые могут использоваться для представления чисел с плавающей запятой или целых чисел.

#### Дополнительная информация:

*   [Википедия на реальные числа](https://en.wikipedia.org/wiki/Real_number)
*   [Числа с плавающей точкой, IEE-754](https://en.wikipedia.org/wiki/IEEE_754)