---
title: Derivatives
localeTitle: производные
---
## производные

Производная - это мгновенная скорость изменения функции или скорость изменения функции в любой конкретный момент времени. Производная является инструментом исчисления, и вы можете определить ее, взяв предел.

Вы можете понять концепцию производной, сравнивая ее с понятием наклона (средняя скорость изменения) в алгебре.

Давайте рассмотрим пример:

Вы решили ехать из Сан-Франциско в Санта-Розу, штат Калифорния, на расстояние примерно 60 миль. Вы делаете диск за один час; таким образом, ваша средняя скорость изменения (скорость) составляет 60 миль в час.

Но вы не путешествовали со скоростью 60 миль в час за каждое мгновение вашей поездки. Вы начали медленнее, затем увеличили скорость и изменили ее по пути, а затем остановились до полной остановки, когда вы прибыли в пункт назначения.

Давайте посмотрим на график вашего путешествия с осью x, представляющей время (в минутах) и ось y, представляющую расстояние (в милях). Pt. A представляет Сан-Франциско с координатами (0, 0) и pt. B представляет Санта-Розу, с координатами (60, 60). Изогнутая линия представляет ваше местоположение, пространство и время, когда вы путешествовали из Сан-Франциско в Санта-Розу.

![образ](https://github.com/MarkMikow/MyFiles/blob/master/img1.png?raw=true)

Вы можете определить среднюю скорость (скорость изменения расстояния за раз) в вашей поездке, взяв наклон алгебры («взлет над пробегом»):

![образ](https://github.com/MarkMikow/MyFiles/blob/master/img2.png?raw=true)

Используя тот же график, вы можете выбрать любые две точки, C (x1, y1) и D (x2, y2) и найти наклон между ними. Более того, вы можете пометить каждую точку, используя нотацию функции, такую, что (x1, y1) становится (x, f (x)) и (x2, y2) становится ((x + h), f (x + h)), с h - горизонтальное расстояние, равное pt. D - из pt. C:

![образ](https://github.com/MarkMikow/MyFiles/blob/master/img3.png?raw=true)

Наклон от pt. C до pt. D:

![образ](https://github.com/MarkMikow/MyFiles/blob/master/img4.png?raw=true)

Выражение ![образ](https://github.com/MarkMikow/MyFiles/blob/master/img5.png?raw=true) называется фактором разности, и вы можете использовать его, чтобы найти среднюю скорость изменения из любой точки графика в любую другую точку на горизонтальное расстояние h единиц.

Чтобы преобразовать среднюю скорость изменения (наклон) в мгновенную скорость изменения (производная, обозначенная как f (x)), вы берете предел разностного фактора:

![образ](https://github.com/MarkMikow/MyFiles/blob/master/img6.png?raw=true)

Это формальное определение производной и означает, что вы принимаете расстояние h и сокращаете его до бесконечно малого количества. У вас все еще есть склон, но его конечные точки бесконечно близки друг к другу. На самом деле они настолько близки, что кажутся как одно очко, или как одно мгновение, со временем.

Так как прямая, касательная к точке на графе, пересекает график только в одной точке, производная также определяется как наклон касательной к любой точке на графе. В примере вышеприведенного графика производная каждой точки - это мгновенная скорость, с которой вы путешествуете.

Производные имеют широкий спектр приложений и используются в физике, технике, экономике и других дисциплинах.