---
title: Factorials
localeTitle: Факториалы
---
## Факториалы

### Определение факториала

Факториал состоит в том, чтобы умножить его на каждый интигер ниже, чем заканчивается на один. Если начальное число отрицательно, результат будет бесконечным.

Факториал n , неотрицательное целое число, определяется как:

п! = 1 \* 2 \* ... \* (n - 1) \* n

При n = 0 возникает особый случай. А именно, 0! = 1 .

### Удобство факториалов

Вышеприведенное определение предоставляет вам удобство при определенных вычислениях. Например, факториалы внутри фракций часто могут быть упрощены следующим образом:

Пример 1: 7! / 5! = (1 \* 2 \* 3 \* 4 \* 5 \* 6 \* 7) / (1 \* 2 \* 3 \* 4 \* 5) = 6 \* 7 = 42

Пример 2: (n + 1)! / n! = (1 \* 2 \* ... \* n \* (n + 1)) / (1 \* 2 \* ... \* n) = n + 1

### Альтернативное определение

В качестве альтернативы факториалы можно определить следующим образом:

0! = 1

п! = n \* (n - 1)! если n> 0

Это рекурсивное определение означает то же самое, что и традиционное определение. Применяя это ко второму примеру выше, получаем:

(n + 1)! / n! = (n + 1) \* n! / n! = n + 1

### Помимо этого: расширение до нецелочисленных

Обратите внимание, что факториал, определенный выше, применяется только к целым неотрицательным целям. На самом деле существует обобщение факториалов, которое также распространяется на нецелые числа, что является гамма-функцией. В частности, для любого натурального числа n вы имеете n! = Gamma (n + 1) = n \* Gamma (n) .

Дополнительные сведения см. В разделе [Расширение факториалов до нецелых значений аргумента](https://en.wikipedia.org/wiki/Factorial#Extension_of_factorial_to_non-integer_values_of_argument) .

Один сложный пример, который многие могут не знать, если 0! = 1. Для дальнейшего доказательства см. Ссылку в разделе «Дополнительная информация».

#### Дополнительная информация:

[Факториалы](http://www.purplemath.com/modules/factorial.htm)