---
title: Limits Intro
localeTitle: Ограничения
---
## рамки

Сказать, что предел функции f (x) означает, что ƒ (x) можно сделать как можно ближе к L, сделав x достаточно близким, но не равным p.

#### пример

Пусть f (x) = x. Тогда предел f (x) при x стремится к 1, равному 1. То есть значение функции при прохождении значений x, 0, затем 0,01, затем 0,1, затем 0,5 и прохождения через все значения по оси x приближаются и приближаются к 1, значение этой функции f (x) = x будет стремиться к 1. Ниже, график функции.

![граф f (x) = x](https://ocw.mit.edu/ans7870/18/18.013a/textbook/HTML/chapter01/images/identity.gif)

Когда говорят, что f (x) очень близко к L, но не «прикасается» к нему, означает, что их расстояние очень мало, также x стремится к a, но не равно a, означает, что x находится на небольшом расстоянии из. Для этого используется определение абсолютной величины.

| f (x) - L | <ε, | x - a | <δ

Символы, эпсилон и треугольник, соответственно, представляют собой сколь угодно малое число.

![предел](http://tutorial.math.lamar.edu/Classes/CalcI/DefnOfLimit_files/image001.gif)

На приведенном выше рисунке показано следующее: для любого небольшого ε> 0 (epsilon), которое вы можете выбрать, можно нарисовать полосу между L + ε и L- ε, которая будет желтой областью или горизонтальной полосой. Затем, выбирая этот эпсилон, существует определенная δ> 0 (дельта), которая может быть определена, что позволяет вам нарисовать вертикальную полосу, как и розовую область на графике выше, розовую, между a + δ и a - δ. Теперь, если вы возьмете любой x в розовой области, то есть вокруг a, тогда этот x будет ближе к a, чем любой из + δ и a - δ. Или же,

| x - a | <δ

Если теперь вы определяете точку на графике, которую дает ваш выбор x, то эта точка на графике будет лежать в пересечении розовой и желтой областей. Это означает, что это значение f (x) будет ближе к L, чем L + ε и L + ε. Или же,

| f (x) - L | <ε

Итак, если вы берете любое значение x в розовой области, тогда график для тех значений x будет лежать в желтой области.

Хорошо, представьте себе следующую ситуацию: вы и ваш друг совершите захватывающее путешествие с помощью карты. Вы будете ездить, и ваш друг будет обрабатывать карту для вас. Теперь, за каждый дюйм на карте, который ваш друг читает вам, автомобиль будет двигаться, предположим, 2Km или 1.24 мили, если вы предпочитаете. Обратите внимание, что, несмотря на то, что мы используем единицы, мы просто можем написать «вашу функцию», как:

f (дюйм) = 2 км

Итак, если ваш друг читает 2 дюйма на карте, вы переместитесь на 4 км. Вы двое сейчас устали и решили отдохнуть, но умные, как вы и ваш друг, вам интересно:

*   Эй, если я склонен читать для вас, с карты, следующие 10 дюймов, мы устали и будем отдыхать время от времени, поэтому я не буду читать вас целых десять дюймов, но я уверен, что буду как можно ближе, как вы думаете, мы будем путешествовать?

Вы можете думать так:

*   Я знаю, что за каждый дюйм, который вы читаете, я проезжаю 2 километра! поэтому, если вы, как правило, читаете 10 дюймов ... хм ... мы, возможно, приблизимся как можно дальше, чтобы проехать 20 километров! Не совсем 20, но мы будем очень очень близки.

Это способ проиллюстрировать эту концепцию, представьте, что вы идете по графику, функция - это ваше «правило», x - «сколько вам нужно ходить», а f (x) - это значение, которое вы на самом деле шли, данное правило, которое вам дано.

#### свойства

Рассмотрим, что существуют пределы функций:

*   **сумма**

![Сумма лимитов](http://tutorial.math.lamar.edu/Classes/CalcI/LimitsProperties_files/eq0004MP.gif)

Предел суммы является суммой пределов.

Пусть f (x) равно x, f (x) = x и g (x) = 2x. Пусть x стремится к 1. Предел:

lim (f (x) + g (x)) = lim f (x) + lim g (x) = lim x + lim 2x = 1 + 2 = 3

Или lim (x + 2x) = lim (3x) = 3

*   **Продукт**

![Продукт ограничений](http://tutorial.math.lamar.edu/Classes/CalcI/LimitsProperties_files/eq0005MP.gif)

Предел произведения является произведением пределов.

Рассмотрим ту же функцию в предыдущем примере, f (x) = x и g (x) = 2x. И сделать x имеет тенденцию к 2, теперь.

lim (f (x) \* g (x)) = lim f (x) \* lim g (x) = 2 \* 4 = 8

Или lim (x \* 2x) = lim (2x ^ 2) = 2 \* 4 = 8

*   **Продукт постоянным**

![Продукт постоянным](http://tutorial.math.lamar.edu/Classes/CalcI/LimitsProperties_files/eq0003MP.gif)

Вы можете «разбить» мультипликативную константу из предела.

Опять же, предположим, что f (x) = x. Предел, учитывая, что x стремится к 5 сейчас:

lim (10 \* x) = 10 lim (x) = 50

lim (10x) = 50

*   **разделение**

![Разделение лимитов](http://tutorial.math.lamar.edu/Classes/CalcI/LimitsProperties_files/eq0006MP.gif)

Предел деления - это разделение пределов.

Пусть f (x) = 2x и g (x) = x + 1. Убедитесь, что функция, которую вы разделите, не равна нулю. сделайте x равным 2, и у вас есть:

lim (2x / x) = lim 2x / lim x = 4/2 = 2

или lim (2x / 2) = lim 2 = 2. Это постоянная функция, поэтому независимо от того, сколько вы будете ходить по оси x, значение всегда будет иметь тенденцию к одному конкретному значению.

*   **Мощность**

![Мощность пределов](http://tutorial.math.lamar.edu/Classes/CalcI/LimitsProperties_files/eq0007MP.gif)

Если n - целое число.

Пусть f (x) равно x + 1 и x стремится к 2. Предположим следующее предел:

lim \[(x + 1)\] ^ 2 = (3) ^ 2 = 9

lim \[(x + 1)\] ^ 2 = lim (x ^ 2 + 2x + 1) = 9 (обратите внимание, что вы также можете использовать свойство sum!)

#### Дополнительная информация:

[Примечания и дополнительные примеры](http://tutorial.math.lamar.edu/Classes/CalcI/LimitsProperties.aspx)

[Введение](https://www.khanacademy.org/math/ap-calculus-ab/ab-limits-continuity/ab-limits-graphically/v/introduction-to-limits-hd)