---
title: Addition and Scalar Multiplication
localeTitle: Добавление и скалярное умножение
---
## Добавление и скалярное умножение

При работе с векторами двумя наиболее распространенными операциями являются добавление векторов и умножение на скаляр.

### Векторное дополнение

Векторное дополнение можно визуализировать следующим образом:

1.  Возьмите «хвост» (конец без стрелки / начало вектора) второго вектора и соедините его (неизмененным) с «кончиком» (конец / конец стрелки) первого вектора. Теперь, если вы создадите новый вектор из хвоста первого вектора на кончик второго вектора, вы останетесь с суммой двух векторов!
    
2.  Вычитание двух векторов почти одинаково. Однако вы должны перевернуть направление второго вектора, а затем продолжить подключение к первому.
    

Очевидно, что вы не хотите рисовать и подключать векторы каждый раз, когда хотите сделать добавление векторов. К счастью, решение на практике намного проще.

Предполагая, что у вас есть два вектора <1,2> ​​и <5, -4>, все, что вам нужно сделать, это добавить соответствующие компоненты:

 <1,2> ​​+ <5, -4> = <1 + 5, 2 + (-4)> = <6, -2> 

Это работает с векторами такого размера, сколько вы хотите, если размеры двух добавленных векторов совпадают. Например, добавив <4, 4, -5, 0> и <2, 4, -1, -29>:

 <4, 4, -5, 0> + <2, 4, -1, -29> = <4 + 2, 4 + 4, -5 + (-1), 0 + (-29)> = <6 , 8, -6, -29> 

### Скалярное умножение

При умножении вектора на скаляр, вы можете думать об этом как о повышении его величины.

Например, при умножении вектора <2, 3> на 2:

 2 \* <2,3> = <2 \* 2, 2 \* 3> = <4, 6> 

Направление сохраняется - только величина увеличивается в 2 раза.

Однако, когда мы умножаем отрицательное число, направление меняется на противоположное. При умножении вектора <2, 3> на -2:

 -2 \* <2, 3> = <-2 \* 2, -2 \* 3> = <-4, -6> 

#### Дополнительная информация: