---
title: What Is a Function
localeTitle: Что такое функция
---
## Что такое функция

Функция математически определяется как отображение одного набора чисел в другое. Например, `f(x) = x*2.` Любой заданный вход из некоторого набора (называемый доменом) всегда дает один конкретный вывод из диапазона. В функции удвоения входы 1,3 и 5 отображаются в числах 2,6 и 10 в диапазоне, что также является совокупностью всех действительных чисел.

Напротив, «функция» в программировании (более точно называемая методом или подпрограммой на некоторых языках) - это метод, который принимает одно или несколько значений и выводит один или несколько выходов. Как правило, нет гарантии, что какое-то внутреннее состояние (например, глобальная переменная) может измениться таким образом, что f (2) может быть 5 за один раз или 10 при повторном запуске. В большинстве разрешенных языков, даже ожидаемых в некоторых случаях, но некоторые языки, использующие _функциональное программирование,_ математически определяют функции как функции, поскольку нет переменных состояния, которые могут меняться и иметь несогласованности, тем самым давая более «доказуемо правильный» код.

#### Дополнительная информация:

Функциональные языки: [Haskell](http://learnyouahaskell.com/chapters) , [Clojure](https://clojure.org/)