---
title: Free Code Camp Style Guide for Algorithms
localeTitle: Руководство по стилю Free Code Camp для алгоритмов
---
Проблемы с написанием алгоритмов - отличный способ реализовать свои собственные задачи по решению проблем и тестированию. Следите за этим процессом, чтобы максимизировать шансы на то, что мы примем ваш алгоритм.

*   `seed_data/Algorithms.json` репозиторий Free Code Camp и откройте `seed_data/Algorithms.json` чтобы ознакомиться с форматом наших алгоритмов.
*   Независимо от сложности вашего алгоритма, поставьте его как последний алгоритм в файле JSON. Измените один из чисел в ID, чтобы убедиться, что ваш алгоритм имеет уникальный идентификатор.
*   В терминале запустите `node seed_data/seed.js` Запустите `gulp` . Вы должны иметь возможность перейти к вашему новому алгоритму на карте задач. Всякий раз, когда вы вносите изменения в Algorithm.json, вам нужно будет обновиться, чтобы увидеть эти изменения в браузере.
*   Решите свой собственный алгоритм. Убедитесь, что ваши тесты работают должным образом и что ваши инструкции достаточно ясны.
*   Отправьте запрос на растяжение в подразделение Staging Free Code Camp и в теле запроса на тягу, ссылку на суть, которая имеет ваше алгоритмическое решение.

Ниже приведено описание каждого из полей алгоритмов.

*   Имя - название вашей задачи. Это нормально для этого, чтобы быть юмористическим, но это должно быть кратким и актуальным для этой задачи.
*   Трудность - попытка оценить трудности по сравнению с существующими задачами алгоритма. Хорошим прокси-сервером для сложности Алгоритма является то, как долго вы его решаете. За каждые 15 минут это требуется, увеличивайте сложность. Например, одночасовой алгоритм должен быть 4.
*   Описание - Отдельные абзацы с разрывом строки. Перед первым пользователем отображается только первый абзац, прежде чем нажать кнопку «Дополнительная информация». Вся необходимая информация должна быть включена в первый абзац. Напишите этот первый абзац как можно лаконичнее. Последующие параграфы должны содержать подсказки или детали, если это необходимо. Если ваш предмет гарантирует более глубокое понимание, вы можете ссылаться на Википедию.
*   Challenge Seed - здесь вы настраиваете то, что будет в редакторе, когда кемпер запускает алгоритм.
*   Тесты - эти тесты - вот что приносит вам жизненный вызов. Без них мы не можем подтвердить точность ответа пользователя. Выбирайте свои тесты с умом. Алгоритмные тесты записываются с использованием библиотеки утверждений Chai.js. Пожалуйста, используйте синтаксис should и expect для чтения для конечного пользователя. В качестве примера того, чего не делают, многие из исходных задач алгоритма написаны с синтаксисом assert, и многие из тестовых примеров трудно читать. Если у вашего алгоритма есть много крайних случаев, вам нужно будет написать много тестов для полного охвата. Если вы обнаружите, что пишете больше тестов, чем пожелаете, вы можете рассмотреть возможность упрощения требований своей задачи. Для уровня сложности с 1 по 3 вам обычно потребуется только 2-4 теста.
*   MDNlinks. Посмотрите на `seed_data/bonfireMDNlinks.js` . Если какая-либо из этих концепций относится к вашему алгоритму, обязательно включите их. Если вы знаете статью MDN, которая не связана здесь, вы можете добавить ее в файл bonfireMDNlinks.js, прежде чем добавлять ее в свой алгоритм.