---
title: Bar Graph Project
localeTitle: Графический проект
---
## Наша цель - изучить основы данных

Визуализация с использованием D3 через этот проект.

![скриншот 2016-05-17 в 5 02 41](//discourse-user-assets.s3.amazonaws.com/original/2X/2/2d46c5c1c76bd03b9e85d450da02695d3f07c75c.png)

## Что такое D3.js?

Для тех, кто не знаком с D3, D3.js - это библиотека JavaScript для управления документами на основе данных. D3 помогает вам воплощать данные в жизнь с помощью HTML, SVG и CSS.

D3.js помогает вам прикрепить свои данные к элементам DOM (Document Object Model). Затем вы можете использовать CSS3, HTML и / или SVG для демонстрации этих данных. Наконец, вы можете сделать данные интерактивными с помощью преобразований и переходов, управляемых данными D3.js.

## Объяснение проекта:

### Сценарий:

Там есть класс студентов онлайн, взаимодействующих с различными темами темы, и дает викторину по этим темам.

Есть 15 тем, и по каждой теме у нас есть несколько учеников, которые прошли викторину и забили в трех категориях: Низкий, Средний и Высокий

### Например (данные):

Тема: «1», низкая: 4, середина: 13, высокая: 18

Тема: «2», низкая: 11, середина: 12, высокая: 6

Тема: «3», низкая: 12, середина: 24, высокая: 6 и так далее.

Обратите внимание, что в теме 1 есть ученик `4 + 13 + 8 = 35` и тема 2 имеет `11+12+6 = 29` учеников, а тема 3 имеет 42 ученика и так далее.

Мы хотим сделать интерактивные диаграммы Bar и Pie. Например, наведите курсор мыши на один из столбцов, соответственно изменив круговую диаграмму и наоборот.

С интерактивной комбинацией гистограммы и круговой диаграммы, где на диаграмме отображается количество студентов, которые взаимодействовали с определенной темой (взята на викторине) и круговая диаграмма, показывающая классификацию результатов обучения студентов в категориях «низкий, средний, высокий», мы можем визуализировать наши данные и получить от них больше данных.

## Советы и ресурсы:

### Пошаговые инструкции:

[**D3 Введение. Здесь**](https://d3js.org) вы можете узнать о выборе, динамических свойствах и переходах в D3.js.

*   В основной функции javascript напишите функцию для обработки гистограммы (гистограмма). Гистограмма покажет общее количество студентов, которые выполнили викторину (взаимодействовали с этой темой) по 15 темам.
    
    *   (Вот [**учебник, в**](https://bost.ocks.org/mike/bar/) котором вы можете узнать, как сделать гистограмму с использованием библиотеки D3 JavaScript. В первом учебном пособии рассказывается, как сделать версию bare-bones в HTML, а затем более полную диаграмму в Scalable Vector Graphics (SVG) и, наконец, анимированные переходы между представлениями.)
*   [Создание SVG для гистограммы](http://codepen.io/SundeepB/pen/CxveH)
    
*   Создайте функцию для сопоставления по оси x и добавьте ось x к гистограмме SVG
    
*   Создайте функцию для отображения оси Y и создайте полосы для гистограммы, чтобы содержать прямоугольники и метки тем.
    
*   Создайте прямоугольники и метки тем
    
*   Создайте функцию для обновления баров. Это будет использоваться круговой диаграммой
    
*   Напишите функцию для обработки pieChart. - круговая диаграмма будет иметь три среза - низкий, средний и высокий, чтобы представлять баллы.
    
    *   [**Учебник, в**](http://zeroviscosity.com/d3-js-step-by-step/step-1-a-basic-pie-chart) котором вы можете узнать, как сделать круговую диаграмму, а затем переходы между представлениями и как создать легенду.
*   Создайте svg для круговой диаграммы.
    
*   Создайте функцию, чтобы нарисовать дуги кусочков пирога - кусочки пирога будут низкими, средними и высокими
    
*   Создайте функцию для вычисления углов среза пирога.
    
*   Нарисуйте кусочки пирога.
    
*   Создайте функцию для обновления круговой диаграммы. Это будет использоваться гистограммой.
    
*   Рассчитайте общую частоту по сегментам для всей темы.
    
*   Вычислите общую частоту по состоянию для всего сегмента.
    

## Результат анализа данных и что мы можем сделать из Визуализации:

*   Начальная круговая диаграмма показывает совокупную классификацию всех баллов студентов по всей теме в трех категориях: «низкий, средний, высокий»,
    
*   Начальная гистограмма, показывающая количество студентов, которые взаимодействовали по этой теме
    
*   Любая выбранная категория из круговой диаграммы обновит гистограмму, показывая количество студентов, которые взаимодействовали по различным темам, имеющим оценку, принадлежащую к этой конкретной категории.
    
*   Скриншоты ниже показывают наведение мыши на срез «Средний» и «Высокий» срез круговой диаграммы соответственно и для этого конкретного фрагмента, тематических гистограмм и количества учеников.
    

![скриншот 2016-05-17 в 5 13 53](//discourse-user-assets.s3.amazonaws.com/original/2X/1/106f06d412df6db5b4a421dc4769d22695cbec72.png)

![скриншот 2016-05-17 в 5 14:05](//discourse-user-assets.s3.amazonaws.com/original/2X/7/7b23ebe89f74f11090984dbc4dc68212e3beceb3.png)

*   На любой выбранной панели бар-диаграммы будет отображаться круговая диаграмма, показывающая классификацию всех учеников по этой конкретной теме на три категории: «Низкая», «Средняя» и «Высокая». Снимок экрана ниже показывает наведение мыши на тему 2 и для этой конкретной темы, сколько учеников находится в категории Низкий, Средний и Высокий

![скриншот 2016-05-17 в 5 13 26:00](//discourse-user-assets.s3.amazonaws.com/original/2X/7/7bd7c613bdb882f2b7c1f76f9778a1bda3e886dd.png)

Ссылки: [1\] Примеры из \[https://d3js.org](https://d3js.org) [2\] D3.js Введение - \[https://www.dashingd3js.com/why-build-with-d3js](https://www.dashingd3js.com/why-build-with-d3js)