---
title: Bitwise Operators
localeTitle: Побитовые операторы
---
`<<` , `>>` , `&` , `|` , `~` , и `^` - поразрядные операторы, которые работают с одним или несколькими битовыми шаблонами или двоичными числами на уровне их отдельных битов.

## И оператор

`x & y`

Делает «поразрядным и». Каждый бит выхода равен 1, если соответствующий бит x И для y равен 1, в противном случае - 0.

## Оператор OR

`x | y`

«Побитовое» или «. Каждый бит вывода равен 0, если соответствующий бит x И для y равен 0, в противном случае это 1.

## Оператор комплемента

`~ x`

Возвращает дополнение x - номер, который вы получаете, переключая каждый 1 для 0 и каждый 0 для 1. Это то же самое, что и -x - 1.

## Оператор XOR

`x ^ y`

«Побитовое исключение или». Каждый бит вывода совпадает с соответствующим битом в x, если этот бит в y равен 0, и это дополнение к биту в x, если этот бит в y равен 1.

## Оператор арифметического сдвига слева

`x << y`

Возвращает x с битами, сдвинутыми влево на y местами (и новые биты в правой части - это нули). Это то же самое, что умножение x на 2 \*\* y, сохраняя знак числа. Большинство компиляторов выдает предупреждение при смене с помощью count> = sizeof (type). Обычно вы получаете 0, когда вы это делаете.

## Оператор арифметического сдвига справа

`x >> y`

Возвращает x с битами, сдвинутыми вправо на y местами. Это то же самое, что и деление x на 2 \*\* y для целых чисел без знака. Правильный сдвиг отрицательного числа со знаком имеет поведение, определяемое реализацией. Большинство компиляторов выдает предупреждение при смене с помощью count> = sizeof (type). Смещение по правому краю может заполнить «пустые» биты оригинальным самым значительным битом (т. Е. Выполнить расширение знака) или может сдвинуться в нулях, в зависимости от платформы и / или компилятора.

## Оператор логического сдвига справа

`x >>> y`

Возвращает x с битами, сдвинутыми вправо на y местами. В отличие от арифметического сдвига, логические сдвиги не выдают знак. Например: -2, представленный в 8 бит, будет 11111110 (потому что самый старший бит имеет отрицательный вес). Смещение его вправо одним битом с использованием арифметического сдвига даст вам 11111111, или -1. Однако логическая сдвиг вправо не имеет значения, что значение может представлять собой число; он просто перемещает все вправо и заполняется слева с помощью 0s. Смещение нашего правого правого бита с использованием логического сдвига дало бы 01111111. Этот оператор не обязательно присутствует на всех языках.