---
title: Create an Npm Module
localeTitle: Создание модуля Npm
---
Модуль NPM представляет собой набор функций Javascript, входящих в дистрибутивный пакет. [NPM](http://www.npmjs.com) поддерживает реестр всех доступных пакетов, а также инструмент, используемый для установки пакетов из своего реестра.

Красота NPM заключается в том, что вы можете собрать пакеты, созданные другими людьми для создания чего-то нового, и кто-то позже мог использовать созданный вами пакет. Если у вас есть код, который вы хотите поделиться с миром, публикация модуля в NPM проста.

## Шаг 1. Создайте свой скрипт.

Я создал эту простую утилиту как `index.js` :
```
var time = new Date().toTimeString(); 
 console.log(time); 
```

## Шаг 2. Создание информации о пакете

Следующим шагом будет создание информации для публикации с вашим пакетом, хранящейся в `package.json` . NPM предоставляет мастер, который упрощает создание этого файла.

Просто запустите `npm init` и ответьте на вопросы.

Ваш `package.json` должен выглядеть примерно так:
```
{ 
  "name": "whattimeisit", 
  "version": "1.0.0", 
  "description": "accurate time retrieval", 
  "main": "index.js", 
  "author": "HoursAndMinutes", 
  "license": "ISC" 
 } 
```

Не забудьте включить ссылку репозитория GitHub, если код находится на GitHub!

## Шаг 3. Создание учетной записи пользователя в NPM.

Чтобы опубликовать пакет для NPM, вам необходимо зарегистрировать учетную запись. Для этого запустите `npm adduser` . Вы можете проверить учетную запись, которая в настоящее время используется с `npm config ls` .

## Шаг 4: Публикация в NPM

Прежде чем опубликовать свой пакет в NPM, проверьте, содержит ли каталог какие-либо файлы, которые вы не хотите публиковать (например, пароли, закрытые ключи и т. Д.). Вы можете добавить их в файл с именем `.npmignore` чтобы исключить их из публикации пакетов. NPM также будет `.gitignore` если у вас есть это.

После того как вы завершили свое содержимое пакета, запустите `npm publish` . Вы можете подтвердить данные своего пакета по адресу [https://npmjs.com/package/yourpackagename](https://npmjs.com/package/yourpackagename) .

### Дополнительная информация:

Создание модулей Node.js [npm](https://docs.npmjs.com/getting-started/creating-node-modules)