---
title: Creating a Project with Django
localeTitle: Создание проекта с помощью Django
---
Теперь, когда мы знаем, как создавать виртуальные среды и использовать pip, мы можем начать строить наш проект. В этой статье мы создадим наш первый проект Django, напишем тесты и запустим наш сервер разработки.

## Создание виртуальной среды

Во-первых, давайте создадим новую виртуальную среду для этого проекта. (Если вы еще этого не сделали, отключите предыдущий файл virtualenv, набрав в терминале `deactivate` ). Для получения дополнительной информации о виртуальных средах и способах их использования посетите эту страницу .

Перейдите в каталог, в котором вы хотите проект Django, и введите в терминал следующее:
```
mkvirtualenv taskplanner --python=/usr/bin/python3 
```

Возможно, вам придется изменить свой путь Python, если он отличается от приведенного выше.

Оболочка командной строки теперь должна выглядеть ниже, указывая, что вы находитесь в виртуальной среде.
```
(taskplanner)<a href='https://sites.google.com/a/chromium.org/chromedriver/downloads' target='_blank' rel='nofollow'>munsterberg@Lenovo ~/workspace] $ 
```

Если это не похоже, просто введите:
```
workon taskplanner 
```

Теперь мы можем установить Django:
```
pip install Django 
```

## Создайте наш проект Django

С установленным Django мы можем создать наш проект:
```
django-admin.py startproject taskplanner 
```

Затем перейдите в наш новый проект, набрав:
```
cd taskplanner 
```

Прежде чем что-либо сделать, давайте установим этот каталог как наш рабочий каталог с помощью virtualenvwrapper:
```
setvirtualenvproject 
```

**Sidenote** : для списка команд `virtualenvwrapper` введите `virtualenvwrapper` в ваш терминал.

Теперь, когда мы находимся в нашей виртуальной среде, мы можем ввести `cdproject` чтобы перейти прямо к нашей рабочей директории.

Каталог проектов должен выглядеть примерно так:
```
taskplanner // our main working directory 
 |--- manage.py // similar to the django-admin script, you will see this used a 
               // lot throughout our project 
 |--- taskplanner 
    |--- __init__.py // this just tells python to treat this directory as a package 
    |--- settings.py // main configuration file for our project 
    |--- urls.py // we will use this to configure urls 
    |--- wsgi.py // this is used for deploying our project to a production server 
```

## Функциональное тестирование

Разработка, основанная на испытаниях, является широко используемой передовой практикой в ​​разработке программного обеспечения. Базисно, мы хотим сначала написать тест, который обязательно сработает, а затем записать наименьшее количество кода для прохождения этого теста. С Django наша цель - написать как функциональные тесты (также известные как интеграционные тесты, сквозные тесты и т. Д.), Так и модульные тесты в процессе разработки. Не потейте, тестирование не так сложно, как кажется!

Но сначала нам нужно создать новую виртуальную среду, предназначенную для тестирования. Откройте новую вкладку в своем терминале, перейдите в каталог проекта проекта и введите:
```
mkvirtualenv taskplanner_test --python=/usr/bin/python3 
```

Теперь у вас должно быть 2 вкладки в вашем терминале, один в виртуальной среде (taskplanner), а другой в виртуальной среде (taskplanner\_test).

Если вы запишете `pip freeze` в нашей новой тестовой среде (taskplanner\_test), вы заметите, что ничего не появляется. Это связано с тем, что мы еще ничего не установили в нашей новой среде.

Итак, давайте начнем и сначала установим Django в нашу тестовую среду (taskplanner\_test):
```
pip install Django 
```

Для создания наших функциональных тестов нам понадобится несколько вещей. Во-первых, нам нужно установить веб-браузер Firefox на нашем компьютере. Если у вас нет Firefox, установите это сейчас.

**Sidenote** : вы можете использовать Chrome для тестирования интеграции, но вам нужно скачать драйвер [здесь](https://sites.google.com/a/chromium.org/chromedriver/downloads) и выполнить [этот вопрос переполнения стека](http://stackoverflow.com/questions/13724778/how-to-run-selenium-webdriver-test-cases-in-chrome) . У Firefox была исторически более высокая производительность, чем хром при выполнении интеграционных тестов, что очень важно, поскольку по сравнению с модульными тестами интеграционные тесты очень медленные.

Это связано с тем, что интеграционные тесты проверяют **всю** систему, а не «единицы» (небольшие компоненты). В реальном мире иногда лучше избегать интеграционных тестов из-за длительного времени разработки для их создания, медленного времени выполнения, неоднозначных ошибок и других причин, которые вы могли бы обнаружить со временем.

Тем не менее, они по-прежнему заслуживают нашего внимания при разработке приложения реального мира и могут быть очень полезными с точки зрения надежности, несмотря на недостатки производительности.

Затем нам нужно установить пакет под названием [Selenium](http://selenium.googlecode.com/svn/trunk/docs/api/py/index.html) . Этот пакет предоставит нам WebDriver, чтобы мы могли контролировать браузер с помощью наших тестов. Selenium обычно используется для автоматизации вашего браузера.
```
pip install selenium 
```

Теперь, когда мы установили это, нам понадобится каталог для создания наших тестов:
```
mkdir functional_tests 
```

В каталоге `taskplanner` вы должны увидеть следующее:
```
taskplanner 
 |-- functional_tests 
 |--- manage.py 
 |--- taskplanner 
    ... 
```

Теперь нам нужно создать несколько файлов в нашей папке `functional_tests` . Мы создадим файл `__init__.py` (это скажет, что python будет рассматривать `functional_tests` такие как пакет) и файл `test_all_users.py` чтобы содержать наши тесты.

Давайте сделаем это сейчас:
```
touch functional_tests/__init__.py 
 touch functional_tests/test_all_users.py 
```

**Sidenote** : `__init__.py` почти всегда пустой файл. Дополнительные сведения о том, для чего он используется, см. В [этом ответе stackoverflow.](http://stackoverflow.com/questions/448271/what-is-init-py-for)

Наконец, мы можем начать писать наш первый функциональный тест! Функциональные тесты предназначены для тестирования фрагментов функциональности в нашем веб-приложении. TDD с Python описывает функциональные тесты как «как приложение работает с точки зрения пользователя».

Итак, давайте `test_all_users.py` файл `test_all_users.py` в нашем текстовом редакторе. Во-первых, мы хотим импортировать webdriver selenium, и сделать это намного проще, Django предоставляет что-то известное как StaticLiveServerTestCase для тестирования в реальном времени. Давайте импортируем оба из них:
```
from selenium import webdriver 
 from django.contrib.staticfiles.testing import StaticLiveServerTestCase 
```

Поскольку мы тестируем с точки зрения пользователей, давайте назовем эти тесты NewVisitorTest. Добавьте следующее:
```
class NewVisitorTest(StaticLiveServerTestCase): 
    def setUp(self): 
        self.browser = webdriver.Firefox() 
        self.browser.implicitly_wait(2) 
 
    def tearDown(self): 
        self.browser.quit() 
```

Во-первых, мы создаем класс StaticLiveServerTestCase с именем NewVisitorTest, это будет содержать наши тесты, которые мы хотим запустить для нового посетителя. Затем мы имеем два метода с именем setUp и tearDown. Метод setUp инициализируется при выполнении наших тестов. Итак, для каждого теста, который мы запускаем, мы открываем Firefox и ждем 2 секунды для загрузки страницы. tearDown запускается после завершения каждого теста, этот метод закрывает браузер для нас после каждого теста.

Теперь мы можем написать наш первый тест, и Firefox откроется и закроется автоматически для нас. Теперь напишем наш тест ниже метода tearDown.
```
    def test_home_title(self): 
        self.browser.get('http://localhost:8000') 
        self.assertIn('Welcome to Django', self.browser.title) 
```

Наш первый тест, как интересно! Давайте пройдем через это. Каждый тест, который мы хотим создать, должен начинаться с «теста». Например, если бы я хотел создать тест для моего css, я бы назвал метод `test_h2_css` . Итак, здесь мы назвали `test_home_title` . Это довольно самоочевидно, что мы и хотим для наших тестов. Сначала метод приводит Firefox к URL- `http://localhost:8000` , а затем проверяет, находится ли «Добро пожаловать в Django» в заголовок заголовка html.

Давайте проверим этот тест и посмотрим, что получится:
```
python manage.py test functional_tests 
```

Во-первых, что именно мы печатаем здесь? Сценарий manage.py предоставляет нам что-то под названием «тест», мы будем использовать его для выполнения всех наших тестов. Здесь мы запускаем его в нашем пакете `functional_tests` , который мы создали с помощью файла `__init__.py` .

После запуска в вашем терминале вы увидите следующее:
```
F 
 ====================================================================== 
 FAIL: test_home_title (functional_tests.test_all_users.NewVisitorTest) 
 ---------------------------------------------------------------------- 
 Traceback (most recent call last): 
  File "/Users/username/url/to/project/taskplanner/functional_tests/test_all_users.py", line 15, in test_home_title 
    self.assertIn('Welcome to Django', self.browser.title) 
 AssertionError: 'Welcome to Django' not found in 'Problem loading page' 
 
 ---------------------------------------------------------------------- 
 Ran 1 test in 4.524s 
 
 FAILED (failures=1) 
```

Так что это провалилось, но это дало нам удобный совет. Во-первых, AssertionError. «Добро пожаловать в Django» не найден в «Странице загрузки проблем». Таким образом, это означает, что заголовок `http://localhost:8000` был «Страница загрузки проблемы». Если вы перейдете к URL-адресу, вы увидите, что веб-страница недоступна.

Попробуем запустить наш сервер Django, чтобы пройти тест. Вернитесь на вкладку терминала, которая находится в виртуальной среде `taskplanner` и запустите наш сервер.
```
python manage.py runserver 
```

Вы должны увидеть что-то вроде следующего:
```
Performing system checks... 
 
 System check identified no issues (0 silenced). 
 
 You have unapplied migrations; your app may not work properly until they are applied. 
 Run 'python manage.py migrate' to apply them. 
 
 March 06, 2016 - 20:53:38 
 Django version 1.9.4, using settings 'taskplanner.settings' 
 Starting development server at http://127.0.0.1:8000/ 
 Quit the server with CONTROL-C. 
```

Не беспокойтесь о сообщении о непримененной миграции.

Теперь, когда у нас есть сервер, запущенный на `http://localhost:8000` , снова запустите наш тест.

Вернитесь на другую вкладку терминала, `taskplanner_test` виртуальной среде `taskplanner_test` и выполните следующее:
```
python manage.py test functional_tests 
```

Вы должны увидеть следующее.
```
Creating test database for alias 'default'... 
 . 
 ---------------------------------------------------------------------- 
 Ran 1 test in 4.033s 
 
 OK 
 Destroying test database for alias 'default'... 
```

## Что мы сделали до сих пор

Наш первый тест!

Мы подробно рассмотрели эту статью. Мы создали наш первый проект, настроили виртуальные среды как для разработки, так и для тестирования, написали наш первый функциональный тест и следовали тестовому процессу разработки, написав неудачный тест, а затем заставив его пройти.

## Использование шаблонов стартера

Вы можете сэкономить много времени, отправив свой проект с шаблоном стартера django. Эти проекты используют лучшие методы, которые помогут вам сэкономить головные боли позже, когда ваш проект будет расти. Некоторые из наиболее популярных проектов:

*   [Cookiecutter](https://github.com/pydanny/cookiecutter-django)
*   [Hackathon starter](https://github.com/DrkSephy/django-hackathon-starter)
*   [край](https://github.com/arocks/edge)