---
title: Design Resources for Front End Developers
localeTitle: Дизайн-ресурсы для разработчиков Front End
---
Вы - внештатный веб-разработчик или вы думаете стать таковым? Возможно, вы участвовали в учебных лагерях по программной разработке или закончили онлайн-курс для начинающих разработчиков? Что будет дальше?

Вы получаете своего первого клиента. Это может быть просто друг, которому нужен персональный сайт. Это не имеет значения. Вы не хотите, чтобы он выглядел дилетантским. Вы хотите, чтобы он выглядел хорошо. Вы хотите, чтобы он выглядел профессионально.

Вот что ...

Хороший дизайн может означать разницу между сайтом, который выглядит «самодельным», и тем, что выглядит профессионально. Если вы собираетесь зарабатывать на front-end-разработке, вы не можете позволить себе создавать сайты, которые не следуют хорошим принципам дизайна. Большинство людей (т.е. потенциальные клиенты) знают, как выглядит хороший дизайн, даже если они не могут сказать вам, почему это - хороший дизайн. Поэтому важно понимать базовые концепции дизайна. Фактически, я бы сказал, что это абсолютно необходимо, если Вы желаете иметь успешную карьеру в качестве внештатного разработчика-фрилансера.

Так с чего же начать? Куда идти, чтобы узнать о дизайне? К счастью, вам не нужно платить деньги, чтобы изучить основополагающие принципы дизайна. Существует много ресурсов, которые совершенно бесплатны. Вот 10 ресурсов (большинство из них бесплатны), которые помогут вам стать внештатным разработчиком, поскольку они помогут вам стать лучшим дизайнером. Удачи!

## 1\. [Hackdesign.org](https://hackdesign.org)

Начнем с основ. Если вы хотите создать привлекательную, профессиональную внешнюю работу, вам абсолютно необходимо изучить основы дизайна. Позвольте мне сказать это еще раз. Вам нужно изучить основы дизайна. Да, это так важно. Поверь мне. Это поможет вам выделиться среди всех внештатных разработчиков, которые не учатся, а это значит, что вы получите больше работы. Больше работы означает больше денег. Смотрите, что я имею в виду? Это важно.

Пройдите уроки Hackdesign от начала до конца и пусть все это погрузится. Если вы хотите, вы можете подписаться на еженедельные уроки, отправленные на ваш адрес электронной почты. Однако вам не нужно это делать. Вы можете просто нажать «просмотреть все уроки» и начать прокладывать себе путь через него. Это довольно подробно. Это не то, что вы собираетесь делать через пару часов. Проведите здесь некоторое время на этом ресурсе.

## 2\. [Дизайн для хакеров](http://designforhackers.com)

Причина Дэвида Кадави для написания книги хорошо подведена в этой цитате:

> «Мы можем создавать листовки, открытки и презентации PowerPoint с анимацией. Мы можем создавать блоги, плакаты и даже кружки кофе ... Но немногие из нас грамотны в дизайне».

То же самое касается создания веб-сайтов. Просто потому, что вы можете создать веб-сайт, который работает, это не значит, что вы можете создать красивый, хорошо продуманный веб-сайт, который работает. Это не значит, что вы можете создать веб-сайт, который выглядит профессионально. Я уверен, вы знаете, что я имею в виду. Хороший дизайн выглядит профессионально. Период. Итак, прочитайте эту книгу. У Kadavy также есть сайт на сайте designforhackers.com, где вы можете подписаться на электронный курс под названием «Design Pitfalls».

## 3\. [Курс UX Crash: 31 Основы](http://thehipperelement.com/post/75476711614/ux-crash-course-31-fundamentals)

Помните, что вы фрилансер, а это значит, что на вас много шляп. Просто знать, как код не собирается сокращать его, если вы хотите быть отличным фрилансером, который пользуется большим спросом.

Этот «крутой курс» Джоэл Марш отлично подходит для изучения основ UX. Он говорит: «Следующий список - это не все, что вы можете узнать в UX. Это быстрый обзор, поэтому вы можете как можно быстрее перейти от нулевого героя». Чего же ты ждешь? Начать!

## 4\. [Курс UX Crash: психология пользователя](http://thehipperelement.com/post/87574750438/ux-crash-course-user-psychology)

Часть вторая из потрясающего урока игры Джоэла Марша: Основы. Он подводит итог, почему это важно:

> «... чем больше вы понимаете чувства, мысли и действия своих пользователей, тем лучше вы дизайнер».

Вы хотите быть отличным разработчиком и отличным дизайнером, не так ли? Если бы вы этого не сделали, вы бы не прочитали это далеко. Ну, как вы собираетесь стать отличным или даже хорошим дизайнером, если вы не знаете о своих пользователях? Вы должны думать об этих пользователях. Они имеют значение, потому что вы строите сайты, которые люди будут использовать. Будьте добры к ним. Узнайте о психологии пользователей.

## 5\. [Палитра материалов](https://www.materialpalette.com/)

Привлекательная цветовая палитра может пройти долгий путь, чтобы сделать дизайн профессиональным. Итак, если у вас есть базовые элементы дизайна, о которых я упоминал выше, но до сих пор не знаю, как применять теорию цвета, поместите этот сайт сейчас и начните использовать его. Просто нажмите на два цвета и, как магия, появится красивая, полноцветная палитра. Другими хорошими сайтами для цветовых палитр являются [**flatuicolors**](http://www.flatuicolors.com) и [**coolors**](http://www.coolors.co) .

## 6\. [Основы Adode Photoshop](https://helpx.adobe.com/photoshop/tutorials.html)

Вам понадобится хотя бы ручка по основам Photoshop, чтобы работать с фотографиями и создавать готовые веб-графики. Просмотрите эти бесплатные учебники Adobe Photoshop CC на сайте Adobe. Они очень хорошо сделаны, охватывают основы, и их будет достаточно, чтобы вы начали!

## 7\. [Основы Adobe Illustrator](https://helpx.adobe.com/illustrator/tutorials.html)

Возможно, вы думаете, что, поскольку вы не художник-график, вам не нужно знать, как использовать Adobe Illustrator. Неправильно! Конечно, возможно, вы не будете создавать свои собственные работы с нуля. Однако, что, если вы хотите использовать чужое векторное искусство? Предположим, что вы нашли красивое векторное изображение на iStock, которое хотите использовать. Однако цвет неправильный или вы хотите удалить часть изображения. Нет проблем. Изучите основы Illustrator и получите работу в кратчайшие сроки!

## 8\. [Элементы типографического стиля, используемые в Интернете](http://webtypography.net)

Типография может показаться немного скучной, но это важно. Даже если вы не передадите всю информацию, представленную здесь, в память, просто зная, что в идеальном мире дизайна этот материал поможет повысить вашу осведомленность. Читайте немного за раз. Мне нравится этот сайт, потому что информация представлена ​​небольшими, легко удобоваримыми лакомыми кусочками. Например, проверьте эту минуту, прочитав на [**пробел**](http://webtypography.net/2.1.7)

## 9\. [_Не заставляйте меня думать_ от Стив Круг](http://www.amazon.com/Dont-Make-Me-Think-Usability/dp/0321344758)

Вы строите сайты, которые будут использовать реальные люди. Вы не хотите, чтобы ваши сайты усложняли жизнь и расстраивали людей. Вы хотите, чтобы ваши сайты упрощали свою жизнь. Хорошо, вам нужно знать что-то о удобстве использования в Интернете, и это классическая книга по удобству использования в Интернете. Джеффри Зельдман, основатель журнала [**A List Apart**](http://alistapart.com/) , говорит, что «если вы разрабатываете, пишите, программируете, владеете или управляете веб-сайтами, вы должны прочитать эту книгу». Хорошо сказано. Прочтите эту книгу.

## 10\. [_Творческий вызов_ Тэннера Кристенсена](http://www.amazon.com/Creativity-Challenge-Experiment-Innovate-Inspire/dp/1440588333)

Наконец, если вы являетесь независимым веб-разработчиком, обладающим множеством шляп, вам нужно будет сохранить свое творчество в отличной форме, а это значит использовать его. В этих книгах содержится 150 интересных задач, направленных на то, чтобы заставить вас думать нестандартно и видеть вещи под другим углом. Введение в книгу подводит итог: «Всякий раз, когда вы чувствуете себя застрявшим или невдохновленным, просто перейдите на случайную страницу и следуйте инструкциям, чтобы завершить творческий вызов, который вы там найдете».
