---
title: Dynamic Urls Using Routeparams in Angular
localeTitle: Динамические адреса, использующие Routeparams в угловом
---
Что делать , если у вас есть много пользователей , отправляющих _вещи_ на ваш сайт? Возможно, ваши пользователи хотят иметь профиль или стену того, _что_ они разместили, и они хотят поделиться им со своими друзьями с помощью URL-адреса? Вы можете это сделать, не biggie!

Допустим, вы использовали
```
>> yo angular-fullstack:route wall 
```

для создания маршрута http://myapp.wherever.com/wall/ для ваших пользователей. Вы хотите получить ссылку на http://myapp.wherever.com/wall/someUsername, чтобы показать конкретные _вещи_ пользователя.  
Перейдите в **/client/app/wall/wall.js** и обратите внимание, что он определяет, какой URL-адрес запрашивает пользователь, прежде чем действовать на него:
```
$routeProvider.when('/wall', … 
```

Вы можете настроить этот путь, чтобы поймать, когда пользователь пытается увидеть профиль, связанный с определенным именем пользователя, например:
```
$routeProvider.when('/wall/:username', … 
```

Двоеточие до «username» указывает, что это переменная, которая затем передается модулю _$ routeParams_ . В **wall.controller.js** включить _$ routeParams_ :
```
.controller('WallCtrl', function ($scope, $routeParams) { … 
```

Затем в **wall.controller.js** вы можете увидеть, какое имя пользователя было запрошено в URL-адресе, обратившись к переменной, сгенерированной _$ routeProvider,_ используя что-то вроде
```
var wallOwner = $routeParams.username; 

```