---
title: Equality Vs Identity Operator
localeTitle: Оператор идентификации равенства Vs
---
В JavaScript есть два оператора, которые могут использоваться для сравнения двух значений: _\==_ и _\===_ . Они кажутся точно такими же, но они работают по-разному, и в некоторых случаях они будут давать разные результаты.

## Оператор акций

Оператор равенства (==) сравнивает два значения после всех необходимых преобразований типов. Давайте рассмотрим несколько примеров:
```
0 == ''             // -> true 
 false == 'false'    // -> false 
```

В первом примере и 0, и '' (пустая строка) подвергаются автоматическому преобразованию. Они оба преобразуются в ложное предоставление:
```
false == false 
```

Это, очевидно, _верно_ . Во втором примере _«false»_ непустая строка оценивается как true, делая все выражение ложным.

## Оператор идентификации

Для сравнения, оператор идентичности (===) вернет true тогда и только тогда, когда оба сравниваемых значения имеют один и тот же тип и имеют одинаковое значение. Если мы попытаемся сравнить значения двух разных типов, он всегда будет возвращать _false_ .
```
false === 0            // -> false 
 0 === ''              // -> false 
 5 === 5                  // -> true 
```

Если быть точным, === проверяет, ссылаются ли две переменные на один и тот же объект или в случае типов значений (например, _int_ , _double_ , _String_ , _bool_ и т. Д.), Если оба они имеют одинаковое значение.
```
var array1 = [ 5, 6, 7 ]; 
 var array2 = [ 5, 6, 7 ]; 
 var array3 = array2; 
 
 array1 === array2      // -> false 
 array1 == array2      // -> false 
 
 array2 === array3      // -> true 
 array2 == array3      // -> true 
```

И _array1,_ и _array2_ имеют одинаковый тип, и они равны, но _массив_ сравнения1 _\=== array2_ возвращает false, поскольку они ссылаются на разные объекты. _array2 === array3_ возвращает true, поскольку обе переменные относятся к одному и тому же объекту.

## Какому оператору я должен пользоваться?

Важно понимать разницу между _\==_ и _\===,_ но какой оператор следует использовать?

При использовании _\==_ оператор JavaScript выполнит все преобразования, необходимые для сравнения двух значений. Кажется, что это действительно удобно, но последствия этого преобразования могут быть запутывающими и вызывать очень сложную задачу отслеживания ошибок.

Дуглас Крокфорд, автор книги « _JavaScript: Хорошие части»_ предполагает, что _\===_ следует использовать везде, а не _\==,_ чтобы избежать потенциальных ошибок. В большинстве случаев вам следует следовать этому совету, если вы специально не хотите использовать автоматическое преобразование типов.