---
title: Freecodecamp Moderator Guidelines
localeTitle: Руководство модератора Freecodecamp
---
# Столпы модерации

Прежде всего, помните, что ваша цель в качестве модератора - служить нашему сообществу:

*   Слушать
*   Быть полезным
*   Не злоупотребляйте своей силой

# Модераторы Gitter

Вот как модераторы справляются с нарушениями нашего [Кодекса поведения](https://www.freecodecamp.com/code-of-conduct) на Gitter:

1.  Модераторы немедленно запретят злоумышленнику.
    
2.  Модераторы отправят им следующее сообщение:
    
    > Это стандартное сообщение, уведомляющее вас о том, что мне пришлось временно запретить вам чаты в FreeCodeCamp.
    > 
    > Я являюсь модератором, действующим от имени нашего сообщества с открытым исходным кодом. Я могу подумать о том, чтобы уклониться от тебя, но сначала ты должен сделать что-то.
    > 
    > 1\. Прочтите наш [**`Code of Conduct`**]([https://www.freecodecamp.com/code-of-conduct) ).  
    > 2\. Пожалуйста, подтвердите, что вы его прочитали.  
    > 3\. Объясните мне, почему вы думаете, что я вас запретил.
    
3.  Основываясь на их ответе, модераторы решат, следует ли запрещать оскорбительный кемпер. Если нарушивший кемпер раньше не был запрещен этим модератором, и если они кажутся почтительными и извиняющимися, модератор может их уничтожить. В рамках политики модераторы будут вести себя вежливо во время этого процесса, независимо от того, насколько плохо себя чувствовал оскорбительный кемпер.
    
4.  Модераторы напечатают краткую информацию о событии и как они ответили на него в [административной комнате](https://gitter.im/freeCodeCamp/admin) . Вот пример того, как выглядят такие резюме:
    
    > Я запретил @username для рассылки спама и отправил им Кодекс поведения. Они сказали, что им жаль и что они честно не понимают, что они делают, считаются спамом. Я их расстрелял.
    > 
    > Я не запрещен @username , Я отправил им Кодекс поведения. Они только сегодня поняли, что их запретили и извинились за то, что они сделали.
    > 
    > Я запрещен @username для преследования. Они сошли с ума. Я рекомендую связаться с Gitter для глобального запрета.
    

Чтобы запретить кого-то, введите следующее в чат:

> `/ban @username`

Если они будут сотрудничать, вы можете позже их уничтожить:

> `/unban @username`

Это работает только в одном номере, поэтому вам может потребоваться запретить им более одного места.

Если турист продолжает прыгать из комнаты в комнату, вызывая проблемы, модераторы могут запросить глобальный запрет в [комнате администратора](https://gitter.im/freecodecamp/admin) .

### Удаление сообщений Gitter

Модераторы имеют возможность удалять сообщения на Gitter. Они должны использовать эту способность только в трех особых ситуациях:

1.  Кто-то разместило порнографическое или графический насильственное изображение.
2.  Кто-то опубликовал ссылку или код, который является злонамеренным по своей природе и может нанести вред другим отдыхающим, которые нажимают на него.
3.  Кто-то запустил чат с большим количеством сообщений о спаме до такой степени (обычно с участием ботов), чтобы полностью отключить чат.

Во всех других ситуациях - даже в ситуациях, когда нарушен кодекс поведения - модераторы не должны удалять сообщение, поскольку это важная историческая запись.

### Не используйте `@/all`

Не используйте _`@/all`_ ни при каких обстоятельствах. Каждый человек в этом чате получит уведомление. В некоторых случаях десятки тысяч людей.

Вместо этого, если вы хотите, чтобы люди видели объявление, используйте размер текста заголовка. Вы можете сделать это, поставив `#` перед первым предложением.

### Не предупреждайте и не угрожаете запретить

Если кто-то нарушает кодекс поведения, не предупреждайте их и не угрожайте их запретить. Вместо этого спокойно запретите их, затем передайте их частным сообщениям и действуйте в соответствии с вышеуказанным протоколом. Никто в комнате не должен знать, что вы запретили человека.

### Не хвастайтесь быть модератором

Не видишь себя выше сообщества. Вы - сообщество. И сообщество доверяет вам, чтобы помочь защитить что-то редкое, что мы все разделяем, - приветственное место для новых разработчиков.

Если вы похвастаетесь тем, что являетесь модератором, люди могут чувствовать себя неловко вокруг вас, так же, как люди могут чувствовать себя неловко вокруг полицейского, даже если они не делают ничего плохого. Это просто человеческая природа.

### Не противоречите другим модераторам

Если вы не согласны с действиями модератора, поговорите с ними наедине или поднимите его в чате мод. Никогда не отменять запрет. Вместо этого, обсудите в моде-чате крутую дискуссию и убедите модератора, что они сами должны отменить свой запрет.

Помните: мы все в одной команде. Мы хотим достойно оценить роль модераторов и представить единый фронт.

# Модерирование GitHub

Модераторы - это волонтеры, у которых есть возможность закрывать проблемы и принимать или отклонять запросы на тягу.

Модераторы имеют две основные обязанности в отношении GitHub:

1.  Оценка и реагирование на проблемы
2.  Запросы QA'ing и Merging Pull

### Оценка и ответ на вопросы

freeCodeCamp - активный проект с открытым исходным кодом. Каждый день мы получаем десятки вопросов, все из которых нужно упорядочивать и помечать.

Существует несколько общих классов проблем:

1.  **Запросы справки по коду** , которые не подходят для проблем.  
    Если проблема явно связана с запросом о помощи, вставьте следующее сообщение, а затем закройте проблему.
    
    > Благодарим вас за сообщение об этой проблеме.
    > 
    > Это стандартное сообщение, уведомляющее вас, что эта проблема, похоже, является запросом о помощи. Вместо того, чтобы просить о помощи здесь, нажмите кнопку **«Справка»** на вызов на freeCodeCamp, который приведет вас в комнату помощи для этой конкретной задачи. Вы также можете просмотреть наш [**полный список официальных чатов**](https://forum.freecodecamp.com/t/free-code-camp-official-chat-rooms/19390) ).
    > 
    > Если вы считаете, что я ошибаюсь, закрывая эту проблему, пожалуйста, откройте ее и добавьте дополнительные разъяснения. Спасибо, и счастливое кодирование.
    
2.  **Проблемы** с ошибкой **или разъяснения** Подтвердите ошибку, если это возможно. При необходимости запрашивайте дополнительные данные, например, «Шаги к воспроизведению». После того, как проблема была воспроизведена или, по крайней мере, считается законной, она `confirmed` это. Затем:
    
    *   Если это простое изменение существующей задачи, флаг, который требуется для `help wanted` и, необязательно, только для `first-timers-only` . При необходимости используйте другие теги.
        
    *   Если проблема важнее, отметьте как `bug` .
        
    *   [Руководство по использованию меток](https://forum.freecodecamp.com/t/free-code-camp-issue-labels/19556)
        
        Если есть какая-либо двусмысленность относительно правильного пути действий по проблеме, не стесняйтесь пометить **`@freeCodeCamp/moderators`** чтобы получить мнения от других модераторов. Флаг как `Discussing` .
        
3.  **Дублирующие проблемы** Если проблема совпадает с другой сообщаемой проблемой, приоритет должен иметь предыдущая проблема. Flag as `Duplicate` , вставьте следующее сообщение, заменяющее `#XXXXX` номером проблемы, затем закройте проблему.
    
    > Благодарим вас за сообщение об этой проблеме.
    > 
    > Это стандартное сообщение, уведомляющее вас о том, что эта проблема очень похожа на проблему #XXXXX , поэтому я закрываю ее как дубликат.
    > 
    > Если вы считаете, что я ошибаюсь, закрывая эту проблему, пожалуйста, откройте ее и добавьте дополнительные разъяснения. Спасибо, и счастливое кодирование.
    
4.  **Исправлено в постановке** Некоторые проблемы были исправлены в стадии постановки, но у них нет другой проблемы в той же теме. Вставьте следующее сообщение, затем закройте проблему:
    
    > Благодарим вас за сообщение об этой проблеме.
    > 
    > Это стандартное сообщение, уведомляющее вас о том, что этот вопрос присутствует в производстве, но он был исправлен в стадии постановки. Из-за этого я закрываю эту проблему. Когда постановка снова будет перенесена на производство, ваша проблема будет решена.
    > 
    > Если вы считаете, что я ошибаюсь, закрывая эту проблему, пожалуйста, откройте ее и добавьте дополнительные разъяснения. Спасибо, и счастливое кодирование.
    
5.  **Bike Shedding** Bike Shedding - пример [закона тривиальности Паркинсона](https://en.wikipedia.org/wiki/Parkinson%27s_law_of_triviality) . Некоторые проблемы просто не стоит исправлять. Если вы считаете, что проблема не стоит усилий, `bikeshedding` как `bikeshedding` , вставьте и заполните следующее сообщение, затем закройте проблему:
    
    > Благодарим вас за сообщение об этой проблеме.
    > 
    > _Дайте краткое объяснение, почему это bikeshedding, форма [закона тривиальности Паркинсона](https://en.wikipedia.org/wiki/Parkinson%27s_law_of_triviality) , поэтому я закрываю его._
    > 
    > Если вы считаете, что я ошибаюсь, закрывая эту проблему, пожалуйста, откройте ее и добавьте дополнительные разъяснения. Спасибо, и счастливое кодирование.
    

### Модераторы

Pull Requests (PR) - это то, как вкладчики freeCodeCamp представляют изменения в репозиторий для рассмотрения. Важно, чтобы эти ОР были правильно отформатированы и прошли тщательное тестирование качества до объединения.

### Требования к запросу и форматированию

Все PR должны соответствовать следующим требованиям, прежде чем они должны быть приняты:

1.  Он должен ссылаться хотя бы на одну открытую проблему, и орган должен также включать `closes #XXXXX` для каждого номера проблемы, который он адресует (заменяя `#XXXXX` номером проблемы)
2.  Это должно быть против **`staging`** ветви
3.  Это должно быть из правильно названной непересекающейся ветви, на личной вилке пользователя freeCodeCamp
4.  В названии должно описываться сделанное изменение
5.  Его название не должно содержать номер проблемы в нем
6.  Его тело должно содержать сведения об изменении, а также уровень тестирования (т. Е. Непроверенный, проверенный локально)
7.  _Связанные_ изменения должны быть сжаты до одного фиксации. Но _соответствующие или заметные_ изменения могут иметь отдельные фиксации.
8.  Код должен пройти все тесты и линять

Если PR не отвечает одному или нескольким из этих требований, откройте обзор GitHub, указав, какой из 8 требований еще не выполнен. Новые участники могут быть отправлены в комнату для [авторов Contributors](https://gitter.im/freeCodeCamp/Contributors) . По усмотрению модератора проблема может быть закрыта.

### Обеспечение качества (QA)

Предполагая, что основные требования к PR соблюдены, все ОР должны пройти некоторый уровень тестирования QA. Самый базовый процесс QA - проверить местонахождение PR на вашем компьютере и проверить измененные функции.

1.  Убедитесь, что вы можете воспроизвести проблему локально.
2.  Убедитесь, что PR действительно устраняет проблему.
3.  Вы можете ответить на вопрос с помощью **«LGTM»** , что означает «выглядит хорошо для меня».
4.  Если у вас есть какие-либо сомнения относительно того, следует ли объединить PR, пусть второй отвечает QA, а затем они могут объединить его.
5.  Если у вас уже есть «LGTM», и вы успешно проводите QA PR, вы должны объединить его.

Если есть какие-либо сомнения в функциональности, вы можете упомянуть **`@freeCodeCamp/moderators`** чтобы получить второе мнение.

### Специальные требования

PR, которые изменяют базовую функцию сайта или делают нетривиальные изменения в UI или UX сайта, должны быть одобрены [@BerkeleyTrue](https://gitter.im/berkeleytrue) или [@QuincyLarson](https://gitter.im/quincylarson) . Если у вас есть какие-либо сомнения, пометьте их комментариями и / или привлеките их внимание к PR через Gitter Chat.

### Другие правила, регулирующие модераторы

Хотя у вас будет доступ на запись в репозиторий freeCodeCamp:

*   **вы никогда не должны вводить код непосредственно в репозиторий freeCodeCamp** . Весь код должен вводить кодовую базу freeCodeCamp в виде запроса на извлечение из вилки репо.
*   вы никогда не должны принимать свои собственные ОР. Они должны быть QA-ed другим модератором, как и с любым другим PR.

# Модераторы форума

Модерирование форума следует тем же принципам, что и модерация Gitter. Ниже описываются небольшие вариации, чтобы учесть отличия от Gitter на платформе Discourse.

Модераторы форума несут ответственность за то, чтобы сделать наше сообщество приятным местом для тех, кто учится и получает помощь. Модераторы форумов будут обрабатывать помеченные сообщения и обрабатывать спам, не по теме и другие неприемлемые разговоры.

### Удаление сообщений форума

Модераторы форумов могут удалять сообщения пользователя. Вы должны делать это только в следующих случаях:

1.  Кто-то разместило порнографическое или графический насильственное изображение.
2.  Кто-то опубликовал ссылку или код, который является злонамеренным по своей природе и может нанести вред другим отдыхающим, которые нажимают на него.
3.  Кто-то наполнил поток множеством сообщений о спаме.

### Работа со спамом

Для первой спам-почты пользователя отправьте им сообщение, объясняющее проблему, и удалите ссылку или отправьте сообщение по мере необходимости. Оставьте примечание в профиле пользователя, в котором объясняется действие, которое вы предприняли. Если проблема не устранена, выполните описанный выше процесс. Тихо заблокируйте пользователя от публикации, а затем отправьте предупреждение с Кодексом поведения. Установите флажок в приватном сообщении, в котором указано, что ваше сообщение является «официальным предупреждением».

Нет необходимости использовать комнату администратора Gitter для сообщения об инцидентах на форуме. Если у вас есть вопросы, обратитесь в раздел форума для [персонала](https://forum.freecodecamp.com/c/staff) .

### Работа с неточными разговорами

Сообщения или темы, которые, кажется, не в том месте, могут быть переклассифицированы или переименованы во все, что было бы уместно.

В исключительных обстоятельствах модератору может быть целесообразно разветвить дискуссию на несколько потоков.

Опять же, если у вас есть какие-либо проблемы или вопросы, сделайте сообщение с вашими действиями в категории «Персонал» и пометьте другого модератора, если вы хотите, чтобы они просмотрели ваши действия по модерации.

# Как стать модератором

Вы вносили вклад в наше сообщество и желали дополнительной власти / ответственности, которая приходит с тем, чтобы быть модератором?

Соберите доказательства, которые показывают вашу полезность в вопросах GitHub и / или помогают отдыхающим на Gitter и наших форумах, и PM в Gitter:

*   [@BerkeleyTrue](https://gitter.im/berkeleytrue)
*   [@CodeNonprofit](https://gitter.im/codenonprofit)
*   [@QuincyLarson](https://gitter.im/quincylarson)

Дополнительные требования:

*   Вы должны включить двухфакторную аутентификацию в своей учетной записи GitHub.
*   Ваш профиль GitHub должен, по крайней мере, иметь ваше имя.
*   На вашей фотографии GitHub должно быть лицо.

Если вы будете одобрены, мы добавим вас в нашу [команду модераторов](https://github.com/orgs/freeCodeCamp/teams/moderators) .

# Как мы удаляем неактивных модераторов

Обратите внимание, что мы часто удаляем моды с проблемами, которые, по нашему мнению, неактивны. Когда мы это сделаем, мы отправим следующее сообщение:

> Это стандартное сообщение, уведомляющее вас о том, что, поскольку вы недавно не были активным модератором, мы удаляем вас из нашей команды Модератора. Мы глубоко ценим вашу помощь в прошлом.
> 
> Если вы думаете, что сделали это по ошибке, или когда вы готовы вернуться и внести больше, просто ответьте на это сообщение, сообщив мне об этом.

# Как работает комната наших авторов

Приглашаем всех в [комнату авторов](https://gitter.im/freecodecamp/contributors) . Это назначенный чат для модераторов и других туристов, которые вносят свой вклад в наше сообщество любыми способами, в том числе через учебные группы.

Мы исходим из того, что участники читают что-либо в этой комнате, которая непосредственно упоминает их с `@username` или направляется на `@/all` . Все остальное не является обязательным. Но не стесняйтесь читать все, что угодно, там и взаимодействовать.

# Как стать модератором на этом форуме

Если вы уже являетесь модератором, вы также можете запросить статус модератора на этом форуме. Сообщение [@michaelhenderson](/users/michaelhenderson) здесь, на форуме, и он проверяет статус Модератора на GitHub, а затем предоставит вам статус модератора.

# Работа с солиситорами

К вам могут подойти организации, которые хотят каким-то образом сотрудничать или ко-брендом с помощью freeCodeCamp. Как только вы поймете, что это то, что им нужно, прекратите разговаривать с ними и попросите их поговорить напрямую с Куинси Ларсоном . Он каждый день получает такие предложения буквально каждый день и в лучшем положении может судить о том, будет ли такое отношение для нашего сообщества (и это редко бывает).

# Определения

> Ключевыми словами «ДОЛЖЕН», «НЕ ДОЛЖЕН», «ТРЕБУЕТСЯ», «СЛЕДУЕТ», «НЕ ДОЛЖЕН», «РЕКОМЕНДУЕТСЯ», «МОЖЕТ» и «ДОПОЛНИТЕЛЬНО» в этом документе интерпретироваться, как описано в [**RFC 2119**](https://www.ietf.org/rfc/rfc2119.txt) .