---
title: Get Screen Size in Pixels
localeTitle: Получить размер экрана в пикселях
---
Могут быть случаи, когда ваше приложение JS должно знать, какой размер экрана должен выполнять определенные действия.

К счастью для нас, есть встроенные функции JavaScript, которые могут легко захватывать различные размеры экрана на устройстве пользователя в пикселях. Что использовать зависит от того, что вы хотели бы сделать.

## Получить разрешение пользователя

Возможно, вы захотите сделать что-то, связанное с разрешением устройства пользователя. В этом случае вы должны использовать встроенные свойства `screen.width` и `screen.height` . Это дает вам размер экрана, с которым вы имеете дело. **Это не та область, с которой вы должны работать на странице; эти значения представляют собой полноту экрана, то есть разрешение дисплея пользователя.**

## Получить размер браузера

Может быть интересное приложение для работы с текущим размером браузера. Если вам нужно получить доступ к этим параметрам, используйте для `screen.availHeight` свойства `screen.availWidth` и `screen.availHeight` . Помните, что это размеры всего окна браузера, от верхней части окна браузера до того места, где браузер встречает панель задач или край вашего рабочего стола, в зависимости от вашей установки.

**Интересное примечание** : `screen.availHeight` также может использоваться для определения того, насколько высока панель задач на компьютере. Если в вашем браузере разрешение `1366 x 768` , а `screen.availHeight` сообщает 728 пикселей, тогда ваша панель задач высотой 40 пикселей. Вы также можете рассчитать высоту панели задач, вычитая `screen.height` и `screen.availHeight` :
```
var taskbarHeight = parseInt(screen.height,10) - parseInt(screen.availHeight,10) + " pixels"; 
 /* 
 For a user that has a screen resolution of 1366 x 768 pixels, their taskbar is likely 40 pixels if using Windows 10 with no added accessibility features. 
 */ 
```

## Размер окна просмотра

Эти свойства интересны и могут быть использованы для создания отличных эффектов. Вы можете использовать `window.innerHeight` и `window.innerWidth` чтобы получить размер окна для веб-страницы по мере того, как пользователь видит его. Эти значения не являются статическими и будут меняться в зависимости от того, что происходит с самим браузером. Другими словами, если сам браузер невелик, эти значения будут меньше, и если браузер будет максимальным, они будут больше.

Если, например, вы работаете в Google Chrome, и вы открываете консоль (ее нужно состыковать со стороной окна), `window.innerHeight` изменится, чтобы отобразить высоту консоли, потому что часть окна будет заблокирована. Вы можете проверить это, вызвав `window.innerHeight` , обратите внимание на значение, затем увеличьте размер консоли и снова вызовите `window.innerHeight` .

Эти свойства также изменятся, если ваш браузер будет максимально или изменен. При максимальном размере браузера свойство `window.innerWidth` будет таким же, как и `screen.width` и `screen.availWidth` (если нет панели задач сбоку, и в этом случае `screen.availWidth` не будет равен). `window.innerHeight` равно количеству области в окне самой страницы (области веб-страницы).

## Получить высоту и ширину веб-страницы

Если вам нужно увидеть, насколько высока или широка ваша веб-страница на самом деле, есть свойства, чтобы захватить эти размеры: `document.body.offsetWidth` и `document.body.offsetHeight` . Эти свойства представляют размер содержимого в теле самой страницы. На странице без содержимого есть `document.body.offsetHeight` близкий к тому же значению, что и `window.innerHeight` зависимости от того, какие поля / отступы заданы на теле документа. Если поля и отступы установлены на `0` в корневом элементе html и в `window.innerHeight` документа, то `document.body.offsetHeight` и `window.innerHeight` будут равны без содержимого.

Эти свойства могут использоваться для взаимодействия с вашей страницей / приложением в зависимости от того, что вы хотите сделать.

## Вывод

Какое свойство использовать только на основе того, что вы хотите сделать. Прочитайте, что каждый из них делает, и решите для себя, какие свойства вы должны использовать для своего проекта.