---
title: Getting Started with Android Development
localeTitle: Начало работы с Android-разработкой
---
Сегодня [Android](https://www.android.com/) стал ведущей операционной системой, используемой в различных устройствах, таких как мобильный телефон, планшеты, часы, телевизор, автомобили и многое другое. Он управляет более чем миллиардом устройств по всему миру. Он основан на ядре Linux. Android была самой продаваемой ОС на планшетах с 2013 года, а на смартфонах она доминирует по любой метрике.

## Предпосылки

Для начала разработки Android вы уже должны знать о нескольких вещах:

*   [Java](https://java.com/en/) : разработка Android в основном выполняется на Java. Это не сложный язык для изучения, но знание того, как оно относится к разработке Android, может сбивать с толку без твердой основы языка. Android Java не совсем стандартная Java, но обучение стандартным Java значительно облегчит вам разработку Android. Для конкретных тем в Java, которые были бы полезны в этом случае, вы можете ссылаться на [эту](http://www.bigknol.com/2016/01/10-prerequisites-for-learning-android.html) ссылку.
*   [XML](http://www.w3schools.com/xml/) : знание XML может быть полезно в ряде связанных с технологией областей, и Android не является исключением. В частности, XML-файлы упрощают объявление элементов пользовательского интерфейса в создаваемых вами приложениях. Прошлый опыт - большой плюс.
*   Настойчивость: наконец, изучение возможностей и возможностей инструментария разработки Android займет много времени. Изучение того, как создать качественное приложение, займет еще больше времени. Не спешите. Держитесь за это и сосредоточьте свое внимание на долгосрочной перспективе. Если вы этого не сделаете, вы будете разочарованы и захотите сдаться.

## инструменты

Сначала убедитесь, что у вас есть все инструменты в вашей системе. **Обратите внимание: пакеты, необходимые для обучения Android, требуют загрузки размером более 1 ГБ, и установка займет от 2 до 3 часов вашего времени.** Вам нужно будет начать создавать приложения для Android:

*   [Последняя версия Java JDK](http://www.oracle.com/technetwork/java/javase/downloads/index.html) : [вот](https://github.com/FreeCodeCamp/FreeCodeCamp/wiki/Java-Introduction) руководство по установке Java на ваш компьютер.
*   [Android Studio](http://developer.android.com/sdk/index.html) : [вот](http://developer.android.com/sdk/installing/index.html) официальное руководство по установке студии Android.
*   Если возможно, устройство Android. Если вы этого не сделаете, это тоже хорошо, поскольку вы можете запустить [эмулятор](http://developer.android.com/tools/devices/emulator.html) для запуска виртуального устройства Android на вашем компьютере.

## Поддержка языка Kotlin

Начиная с Android Studio 3.0, инструментальная поддержка Kotlin поставляется непосредственно в Android Studio. **Kotlin** - это статически типизированный язык программирования, который работает на виртуальной машине Java, а также может быть скомпилирован в исходный код JavaScript. Kotlin предназначен для взаимодействия с Java-кодом и зависит от кода Java от существующей библиотеки классов Java, такой как структура коллекций. **Kotlin** предназначен для объектно-ориентированного языка промышленного уровня и «лучшего языка», чем Java, но по-прежнему полностью совместим с Java-кодом, что позволяет компаниям постепенно переходить с Java на Kotlin.

Некоторые из преимуществ использования Kotlin в Android Development:

*   Котлин требует меньше кода для написания.
*   На Котлине происходит меньше раздавливаний.
*   Котлин - это язык безопасности.
*   Котлин спасает вас от вашего драгоценного времени.

## Учебники

Некоторые базовые курсы и учебные пособия для обучения Android:

*   [Официальное руководство для разработчиков Android](http://developer.android.com/training/index.html) : для новичков этот сайт имеет всесторонний раздел обучения, который варьируется от настройки вашей среды и создания вашего первого приложения для Android, вплоть до распространения окончательного приложения и зарабатывания денег в Play Маркете. Для продвинутых пользователей всегда найдутся руководства и ссылки API, которые помогут найти наиболее эффективные решения проблем, связанных с развитием приложений. Это руководство также содержит ссылки на конкретные видеокурсы, необходимые для потребностей разработчиков для расширенных тем развития.
*   [CodePath Android Cliffnotes](https://guides.codepath.com/android)
*   [TutorialsPoint](http://www.tutorialspoint.com/android/)
*   [Vogella](http://www.vogella.com/tutorials/android.html)

## Ресурсы

Вот некоторые полезные ссылки на библиотеки для разработки Android:

*   [Удивительный](https://github.com/wasabeef/awesome-android-ui) список [пользовательских интерфейсов Android](https://github.com/wasabeef/awesome-android-ui) от Wasabeef
*   Список [удивительных Android-библиотек](https://github.com/snowdream/awesome-android) от SnowDream
*   Список замечательных [Android-библиотек](https://github.com/wasabeef/awesome-android-libraries) от Wasabeef