---
title: Getting Started with Sass
localeTitle: Начало работы с Sass
---
### Введение

Sass означает «Синтаксически удивительные стили» и является предварительным процессором CSS. Предпроцессор компилирует код, написанный на определенном языке, вплоть до «продукта», который является машиносчитываемым (доступен для браузера). В основном, Sass компилирует код до обычного CSS, который могут интерпретировать наши браузеры! _Зачем писать код в Sass, когда CSS уже существует?_ Короткий ответ - Sass поставляется с более мощными функциями, встроенными в свой синтаксис, которые позволяют разработчикам писать DRY-er, масштабируемый и более удобный интерфейс.

Если вы знакомы с CSS, то обучение Sass будет немного легче для вас. Если нет, возможно, было бы идеально начать изучать некоторые основы CSS в разделе HTML5 и CSS Free Code Camp в разделе «Сертификация разработки Front End Development», а также взглянуть на [статью CSS MDN](https://developer.mozilla.org/en-US/docs/Web/CSS) .

В первой части этой статьи я расскажу, как установить Sass на ваш компьютер и как скомпилировать ваш Sass-написанный код в CSS.

## Монтаж

Самый простой способ установки Sass на ваш компьютер - через командную строку. Sass является камнем Ruby и потребует следующую команду:

Для компьютеров Mac и ПК:

`sudo gem install sass`

Для Linux вам необходимо сначала установить язык Ruby, а затем:

`sudo su -c "gem install sass"`

Теперь вы можете проверить версию Sass:

`sass -v`

И он должен вернуть что-то похожее:

`Sass 3.4.21 (Selective Steve)`

Если так, поздравляю, вы только что установили Sass! Теперь на использование Sass.

## Основное использование и синтаксис

Начнем с очень простого примера, чтобы проиллюстрировать, как работает Сасс. Вы можете следовать за шагами или просто читать.

_Объяснение импорта: Sass можно записать в двух немного разных стилях, каждый из которых имеет свои преимущества. Один стиль будет использовать расширение файла_ `.sass` _а другое будет использовать_ `.scss` . _Ниже даются краткие объяснения различий двух стилей. Для подробного объяснения ознакомьтесь с_ [статьей](http://thesassway.com/editorial/sass-vs-scss-which-syntax-is-better) _Джона У. Лонга по_ [Сасу и SCSS](http://thesassway.com/editorial/sass-vs-scss-which-syntax-is-better) .

_Для обеспечения согласованности эта статья предоставит примеры кода в формате `.scss` , однако оба стиля одинаково популярны._

Хорошо, давайте начнем. Мы создадим новую папку для размещения наших примерных файлов (вы можете сделать это где угодно на своем компьютере и можете использовать командную строку или сделать это вручную).

В папке мы создадим файл под названием `style.scss` и HTML-файл в стиле `index.html` :

_Команда `tree` на изображении выше - это пакет npm, который вы можете установить, и не является родным для командной строки. Команда `ls` существу делает то же самое._

Теперь, когда у нас есть настройка папки проекта, мы можем использовать команду Sass watch, чтобы «следить» за нашим Sass-файлом и компилировать наш код, когда он обнаруживает изменение в файле. Мы вводим команду watch в файле, который хотим посмотреть:

`sass --watch style.scss`

Следующий шаг - открыть папку проекта в выбранном текстовом редакторе. После того, как наши файлы открыты и готовы к редактированию, мы можем добавить очень базовую HTML-страницу (для нас стиль), которая будет выглядеть следующим образом:
```
<!DOCTYPE html> 
 <html lang="en"> 
 <head> 
  <meta charset="UTF-8"> 
  <title>Sass!</title> 
  <link rel="stylesheet" href="style.css"> 
 </head> 
 <body> 
  <article> 
    <h1>Hello World</h1> 
    <p class="cat-paragraph-1">Cat ipsum dolor sit amet, stand in front of the computer screen, so chase imaginary bugs has closed eyes but still sees you caticus cuteicus.</p> 
    <p class="cat-paragraph-2">Drink water out of the faucet chew on cable or if it fits, i sits roll on the floor purring your whiskers off.</p> 
  </article> 
 </body> 
 </html> 
```

После настройки HTML мы можем открыть наш файл `style.scss` и начать стилизацию в Sass. В приведенном ниже примере кода вы, вероятно, заметите, как некоторые селектора стиля вложены в селектор статей; что-то уникальное для Сасса. Не волнуйтесь, синтаксис будет объяснен в Части 2. На данный момент мы просто хотим получить представление о том, как Сасс работает в своей простейшей форме.
```
article { 
  h2 { 
    font-family: Arial; 
    color: blue; 
  } 
  .cat-paragraph-1 { 
    color: red; 
  } 
  .cat-paragraph-2 { 
    color: green; 
  } 
 } 
```

После того, как этот код был введен и сохранен в файле `style.scss` , задача часов, которую мы перенесли в командную строку, обнаружит изменение в файле, скомпилирует наш Sass to CSS и `style.css` новый файл под названием `style.css` . Вы также можете увидеть файл с именем `style.css.map` в папке вашего проекта, который также волшебным образом появился. Этот файл называется sourcemap и очень полезен при отладке Sass, но пока мы просто оставим его.

Ниже мы видим файлы, перечисленные в папке проекта.

И теперь, если мы откроем `index.html` в веб-браузере, мы сможем увидеть нашу HTML-страницу, используя CSS, который был скомпилирован из образца кода Sass. Аналогично, мы можем открыть файл `style.css` чтобы увидеть, как Sass выводит исходный код Sass. Компактный, не так ли?

## Куда пойти отсюда?

_Большой! Теперь я знаю, как скомпилировать Sass на моем компьютере. Это оно?_

Отнюдь не. Это был простой пример того, как работает Сасс, поэтому преимущества написания в Sass over vanilla CSS могут быть не очевидны. В результате мы написали 12 строк «Sass» и получили 7 строк CSS. Не совсем важная разница по любым стандартам. В Части 2 мы объясним **магию** синтаксиса Sass, такую ​​как переменные и mixins, и то, как использование таких инструментов может предоставить нам сверхдержавы при стилизации.

Если вы все еще зацикливаетесь на том, как Sass магически компилируется в CSS, или, может быть, вам [захочется](http://www.sassmeister.com/) еще раз [поработать](http://www.sassmeister.com/) с образцом кода, [Sassmeister](http://www.sassmeister.com/) - отличный интерактивный интерфейс, который позволяет писать в синтаксисе Sass и мгновенно видеть ваш код, скомпилированный в CSS без необходимо установить что-либо или выполнить любую настройку на вашем компьютере. Это очень полезный ресурс для песочницы и тестирования вашего кода Sass.