---
title: Git Behind a Proxy Server
localeTitle: Git за прокси-сервером
---
**Случаи применения**

Возможно, вам придется изменить команды `git` которые получают доступ (для обновления и чтения) удаленных репозиториев, если ваш интернет-доступ осуществляется через [прокси-сервер](https://en.wikipedia.org/wiki/Proxy_server) .

Прокси-серверы распространены в среде колледжей и бизнес-типов.

Вы можете [найти свои настройки прокси](http://www.wikihow.com/Change-Proxy-Settings) на панели [настроек](http://www.wikihow.com/Change-Proxy-Settings) вашего браузера.

## Использование прокси с Git

После того, как вы получили настройки прокси-сервера (URL-адрес сервера, порт, имя пользователя и пароль); вам нужно настроить git следующим образом:
```
$ git config --global http.proxy http://<username>:<password>@<proxy-server-url>:<port> 
```

Вам нужно будет заменить `<username>` , `<password>` , `<proxy-server-url>` , `<port>` значениями, специфичными для ваших учетных данных прокси-сервера. Эти поля являются необязательными. Например, ваш прокси-сервер может даже не требовать `<username>` и `<password>` , или что он может работать на порту 80 (в этом случае `<port>` не требуется).

После того, как вы установите их, ваш `git pull` , `git push` или даже `git fetch` будут работать правильно.

## Когда не использовать

Вам не нужно использовать команды `git` с настройками прокси-сервера, если произойдет одно из следующих действий:

*   Системный администратор или корпоративная политика не позволяет вам обращаться к удаленным репозиториям `git` из GitHub, BitBucket и т. Д.
*   Удаленный репозиторий, о котором идет речь, не находится в вашей машине, но находится во внутренней сети. Хорошим примером является экземпляр GitLab, развернутый внутри вашей компании.

## Отменить настройки прокси-сервера

Используйте [это](http://stackoverflow.com/questions/11499805/git-http-proxy-setting) обсуждение переполнения стека, чтобы отключить настройки прокси-сервера.

## Ресурсы

Вы можете использовать следующее для дальнейшего чтения:

*   [Могу ли я войти в прокси-сервер](https://help.github.com/desktop/faq/articles/can-i-log-in-behind-a-proxy-server/#platform-windows)
*   [Git Config](https://git-scm.com/docs/git-config)