---
title: Git Pull Vs Git Fetch
localeTitle: Git Pull Vs Git Fetch
---
Эти две команды регулярно используются пользователями git. Давайте посмотрим разницу между обеими командами.

Ради контекста, стоит помнить, что мы, вероятно, работаем в режиме клонирования. Что такое клон? просто дубликат другого репозитория. Это в основном получение вашей собственной копии чужого исходного кода.

Тем не менее, чтобы ваш клон обновлялся с любыми изменениями, которые могли быть применены к оригиналу, вам нужно довести их до вашего клона. Вот откуда `fetch` и `pull` . `git fetch` - это команда, которая сообщает вашему локальному git получать самую последнюю информацию метаданных из оригинала (но не делает никакой передачи файлов. Это больше похоже на проверку, если есть какие-либо изменения доступны). `git pull` с другой стороны делает, что AND приносит (копирует) эти изменения из удаленного репозитория.

Например
```
git pull origin ankur bugfix 
```

Убрать это, чтобы иметь в виду, что на вашей рабочей станции обычно есть как минимум три копии проекта. Один экземпляр - это ваш собственный репозиторий с вашей собственной историей фиксации (уже сохраненный, так сказать). Второй экземпляр - это ваша рабочая копия, где вы редактируете и строите (еще не совершено ваше репо). Третья копия - это ваша локальная «кэшированная» копия удаленного репозитория (возможно, оригинал, из которого вы клонировали ваш). Вы можете использовать `git fetch` чтобы узнать изменения, сделанные в удаленном репо / ветке с момента последнего нажатия. Это полезно для проверки перед фактическим нажатием, которое может изменять файлы в вашей текущей ветке и рабочей копии (и, возможно, потерять ваши изменения и т. Д.).
```
git fetch 
 git diff ...origin 

```