---
title: Heroku Deployment Guide
localeTitle: Руководство по развертыванию Heroku
---
1.  Создайте учетную запись Heroku.
    
2.  После создания учетной записи вы можете перейти на свою [панель инструментов](https://dashboard.heroku.com/apps)
    
3.  Нажмите знак «+» в верхнем правом углу и нажмите «Создать новое приложение» (точно так же, как вы создаете новый репо на github). Дайте ему имя и нажмите «Создать».
    
4.  После создания приложения вы увидите его имя на панели управления. Нажмите здесь.
    
5.  Вы попадете на панель инструментов для этого приложения. Перейдите на вкладку «Развернуть».
    
6.  Там вам будет приятно узнать, что вы можете подключиться к репозиторию github. В разделе «Метод развертывания» выберите GitHub и выполните аутентификацию, подписавшись в GitHub.
    
7.  Прямо под этим, заполните свое имя рефинансирования github. (Это, конечно, требует, чтобы вы переместили репозиторий в github либо из облака9, либо из вашей локальной машины ... и что вы правильно настроили его. Подробнее об этом ниже.)
    
8.  Прокрутите страницу вниз и нажмите «Автоматическое развертывание» или прокрутите страницу вниз еще раз и нажмите «Ручное развертывание». Через несколько минут вы увидите, что ваше приложение работает на вашем -repo-name.herokuapp.com. Милая.
    

## Создание приложения локально или на Cloud9

1.  Создайте новую папку под названием timestamp-microservice (или независимо от вашего проекта).

`$ mkdir timestamp-microservice && cd timestamp-microservice`

1.  Создайте файлы, которые вам понадобятся:

`$ touch .env .gitignore README.md index.html server.js`

1.  Установите пакеты, которые вам нужны по пути

Примеры:

`$ npm install --save express`

`$ npm install --save moment`

Они будут добавлены в папку node\_modules в корневой папке.

1.  Инициализировать проект с помощью package.json, выполнив `$ npm init`

Он задаст вам ряд вопросов и создаст файл package.json в корневой папке на основе ваших ответов и настроек по умолчанию. Если вы уже создали файл с именем server.js, как упоминалось выше, эта _существенная_ строка будет добавлена ​​в ваш файл package.json:
```
  "scripts": { 
 
  "start": "node server.js" 
 
  } 
```

Если вы назовете это что-нибудь еще, то, как и index.js, эта строка не будет добавлена, и вам придется вручную добавить это. Это поведение по умолчанию, как указано [здесь](https://docs.npmjs.com/files/package.json#default-values) . Вы можете установить модули узла до или после этого шага, и они автоматически добавятся в package.json.

1.  Когда вы будете готовы, создайте новый репозиторий на github, скопируйте удаленный URL-адрес и инициализируйте проект локально, выполнив следующие действия:

`$ git init`

`$ git add .`

`$ git commit -m "initial commit"`

`$ git remote add origin <your github url>`

`$ git push -u origin master`

Совет. В файле server.js обязательно используйте `app.listen(process.env.PORT || <default port>)` чтобы приложение работало на heroku.

Вернитесь к шагу 7 выше.
