---
title: How to Contribute Via a Pull Request
localeTitle: Как внести вклад через запрос Pull
---
> Запрос на перенос (PR) - это метод подачи вкладов в проект с открытым исходным кодом. Часто это предпочтительный способ представления вкладов в проект с использованием системы управления распределенной версией (DVCS), такой как Git.

FreeCodeCamp - это проект с открытым исходным кодом, и все содержимое свободно редактируется.

*   [Выполните](https://help.github.com/articles/fork-a-repo/) проект на GitHub.
*   [Скопируйте](https://help.github.com/articles/cloning-a-repository/) его на локальную машину. Не редактируйте онлайн в github.com, так как редактор может вызвать проблемы с форматированными данными JSON.
*   [Создайте ветку](https://help.github.com/articles/creating-and-deleting-branches-within-your-repository/) с `fix/some-bug` формы `fix/some-bug` или `feature/add-cool-thing` и внесите изменения в эту ветку и зафиксируйте их.
*   [Нажмите кнопку](https://help.github.com/articles/pushing-to-a-remote/) в Интернете (если вы редактируете локально).
*   [Создайте запрос на растяжение](https://help.github.com/articles/creating-a-pull-request/) против ветви **«промежуточной»** .
*   Название (также называемое субъектом) вашего PR должно описывать ваши изменения. т.е. `fix typo in basic-javascript challenge`
*   Если PR предназначен для исправления конкретной проблемы, добавление к концу сообщения о фиксации PR `closes #1337` . Это говорит GitHub о закрытии этой проблемы, если PR объединяется.
*   НЕ добавляйте номера проблем в название PR. т. е. `minor improvements in basic-javascript challenge`

Это общие рекомендации для PR, которые работают в большинстве проектов. Это дает каждому краткое руководство по вашим изменениям при просмотре истории совершения проекта.

_Примечание. Не все запросы на получение принимаются. Разработчики проектов FCC объяснят причину непринятия._

## Дальнейшее чтение

*   [Обучение GitHub & Git](https://www.youtube.com/playlist?list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-) - Как использовать Git и GitHub
*   [Руководство по вступлению в FreeCodeCamp](https://github.com/FreeCodeCamp/FreeCodeCamp#contributing)
*   [Как писать сообщения Git commit](http://chris.beams.io/posts/git-commit/)
*   [Как клонировать FCC на ПК с ОС Windows](https://forum.freecodecamp.com/t/how-to-clone-and-setup-the-free-code-camp-website-on-a-windows-pc/19366)