---
title: How to Log in to Your Local Instance of Free Code Camp
localeTitle: Как войти в свой местный лагерь свободного кода
---
Это руководство поможет вам войти в свой локальный сайт FCC, используя учетную запись GitHub. Этот процесс должен быть аналогичным для входа в систему с другими учетными записями в социальных сетях. В этом руководстве предполагается, что у вас уже есть локальная копия FCC.

## TL; DR

1.  [Зарегистрировать новое приложение OAuth](https://github.com/settings/developers)
2.  Домашняя страница: `http://localhost:3000/`
3.  Поле обратного вызова: `http://localhost:3000/auth/github/callback`
4.  Скопируйте / вставьте идентификатор клиента и секрет клиента в файл `.env`
5.  Использовать порт 3000 при просмотре локального сайта FCC

Free Code Camp Issue Моды и персонал всегда готовы помочь с Pull Request, связанные с этим вопросом в нашем [чате Help Chat Chat](https://gitter.im/FreeCodeCamp/HelpContributors)

## отказ

Вывод от запуска `$ gulp` упоминает **порт доступа** 3001. Я только успешно вошел в систему с GitHub на порту 3000 - **прокси-порт** . Если вы понимаете, как войти в систему, используя другие порты, рассмотрите возможность отправки запроса на перенос в этой вики.

## Вход в систему с использованием учетной записи GitHub

1.  [Зарегистрируйте новое приложение OAuth](https://github.com/settings/developers) и нажмите « **Зарегистрировать новое приложение».**

_В качестве альтернативы_ щелкните свой **профиль Picture** => **Настройки** => **Приложения** => **Приложения для** **разработчиков** => **Зарегистрировать новое приложение**

![Зарегистрировать приложение GitHub OAuth](//discourse-user-assets.s3.amazonaws.com/original/2X/5/55f4645c3498ceb8098afe8e8353da8f7c262548.png)

1.  Заполните поля приложения OAuth
    
    *   **Имя приложения** - выберите любое имя, например, `fcc-local`
        
    *   **URL главной страницы** - установлен на `http://localhost:3000/`
        
    *   **Описание приложения** - необязательный
        
    *   **URL-адрес отзыва авторизации** - устанавливается на `http://localhost:3000/auth/github/callback`
        
2.  Нажмите « **Зарегистрировать приложение»,** чтобы просмотреть новую зарегистрированную страницу приложения с идентификатором клиента и секретностью клиента.
    

![Идентификатор клиента и секрет клиента](//discourse-user-assets.s3.amazonaws.com/original/2X/c/c43ee37a9f0f228d3663bb28accedc14cca3ff56.png)

1.  Скопируйте и вставьте идентификатор клиента и секрет клиента в свой `.env` файл.

_Примечание: ваш идентификатор клиента и секрет клиента будут длинными буквенно-цифровыми значениями._

![Обновить файл .env](//discourse-user-assets.s3.amazonaws.com/original/2X/5/549aeaa6ea85e119ba5e978c708dc55c39b134b3.png)

## подсказки

1.  Удалить / отключить с комментарием блокировать нежелательного провайдера в [паспорт-провайдере](https://github.com/FreeCodeCamp/FreeCodeCamp/blob/staging/server/passport-providers.js) .
    
2.  Добавьте СЕССИЮ _СЕКРЕТНОСТИ и_ `.env` _COOKIE_ в `.env` если вы получите ошибку в express-session и cookieParser.
    
    `COOKIE_SECRET='secret' SESSION_SECRET='secret'`
    
3.  Запустите командный `node seed` перед запуском `gulp` если вы не получите проблем.
    

## Законченный

Поздравляем! Теперь вы можете успешно войти в свой локальный сайт FCC, используя свою учетную запись GitHub.