---
title: How to Make a Pull Request on Free Code Camp
localeTitle: Как сделать запрос на получение бесплатного кодового лагеря
---
# Бесплатный запрос Camp Camp Pull

**Что такое запрос Pull?**

Запрос на выталкивание (PR) - это способ представления предлагаемых изменений в Repo Repo свободного кода (или любого Репо, если на то пошло). Вы внесете изменения в копии файлов, которые составляют Free Code Camp, в личной вилке, а затем примените их, чтобы они были приняты самим Free Code Camp.

## Нужна помощь?

Free Code Camp Issue Моды и сотрудники готовы помочь с вопросами, связанными с Pull Request, в нашем [чате Chat Help.](https://gitter.im/FreeCodeCamp/Contributors)

## методы

Существует два метода создания Pull for Free Code Camp:

1.  Редактирование файлов через интерфейс GitHub
2.  Редактирование файлов на локальном клоне

## Важно: ВСЕГДА РЕДАКТИРУЙТЕ НА ФИЛИАЛ

Уберите только одно из этого документа, это должно быть так: никогда, НИКОГДА не делайте изменения в `staging` ветку. ВСЕГДА создайте новую ветвь перед редактированием файлов. Это важно, потому что, если ваш PR не принят, ваша копия `staging` будет навсегда захудана, и единственный способ исправить это - удалить вилку и перекрёсток.

## Редактирование через локальную вилку (рекомендуется)

Это рекомендуемый метод. Читайте о том, [как настроить и поддерживать локальный экземпляр Free Code Camp](http://forum.freecodecamp.com/t/how-to-fork-and-maintain-a-local-instance-of-free-code-camp/19116) .

1.  Выполните этап перебазирования обслуживания `staging`
2.  Убедитесь, что вы находитесь на `staging` ветке с использованием `git status` :

\`  
$ git статус  
При организации филиала  
Ваш филиал обновлен с помощью «origin / staging».

ничего не делать, рабочий каталог чист  
\`

1.  Если вы не находитесь в стадии постановки или ваш рабочий каталог не является чистым, разрешите любые выдающиеся файлы / фиксации и `git checkout staging`
2.  Создайте ветку от `staging` с git: `git checkout -B branch/name-here` Примечание: Именование наименований важно. Используйте имя, например, `fix/short-fix-description` или `feature/short-feature-description` Просмотрите [Руководство](https://github.com/FreeCodeCamp/FreeCodeCamp/blob/staging/CONTRIBUTING.md) по [взносам](https://github.com/FreeCodeCamp/FreeCodeCamp/blob/staging/CONTRIBUTING.md) для более подробной информации.
3.  Редактируйте свои файлы локально с помощью выбранного вами редактора
4.  Проверьте `git status` чтобы увидеть неустановленные файлы.
5.  Добавьте отредактированные файлы: `git add path/to/filename.ext` Вы также можете сделать: `git add .` для добавления всех неустановленных файлов. Будьте осторожны, потому что вы можете случайно добавить файлы, которые вы не хотите добавлять. Сначала проверьте свой `git status` .
6.  Зафиксируйте свои изменения: `git commit -m "Brief Description of Commit"`
7.  [Сквош свои коммиты](http://forum.freecodecamp.com/t/how-to-squash-multiple-commits-into-one-with-git/13231) , если их больше одного.
8.  Нажимайте свои фиксации на свою вилку GitHub: `git push -u origin branch/name-here`
9.  Перейти к общим шагам

## Редактирование через интерфейс GitHub

**Примечание.** Редактирование через интерфейс GitHub не рекомендуется, так как невозможно обновить вилку через интерфейс GitHub без удаления и повторного создания вилки.

1.  Создать вилку ретрансляции FCC
2.  [Создайте ветку](https://help.github.com/articles/creating-and-deleting-branches-within-your-repository/) внутри своей вилки. Примечание. Именование наименований важно. Используйте имя, например, `fix/short-fix-description` или `feature/short-feature-description` Просмотрите [Руководство](https://github.com/FreeCodeCamp/FreeCodeCamp/blob/staging/CONTRIBUTING.md) по [взносам](https://github.com/FreeCodeCamp/FreeCodeCamp/blob/staging/CONTRIBUTING.md) для более подробной информации.
3.  Отредактируйте файл и зафиксируйте изменения.
4.  Перейдите к общим шагам.

## Общие этапы

1.  После того, как изменения будут исправлены, вам будет предложено создать запрос на перенос на странице GitHub на вилке.
2.  По умолчанию все запросы на отгрузку должны выполняться против основного репозитория FCC, `staging` ветви.
3.  Сделайте четкий заголовок для своего PR, который кратко показывает, что фиксируется. Не добавляйте номер проблемы в заголовок. Примеры: `Add Test Cases to Algorithm Drop It` примеры `Add Test Cases to Algorithm Drop It` `Correct typo in Challenge Size Your Images`
4.  В теле вашего PR содержится более подробное изложение сделанных вами изменений и почему.
5.  Укажите, были ли вы протестированы на локальной копии сайта или нет.
6.  Если ваш PR вызван проблемой, вы можете автоматически [ссылаться и закрывать эту проблему](https://help.github.com/articles/closing-issues-via-commit-messages/) , добавив ключевое слово, например `Closes #xxxx` , где `xxxx` - номер проблемы.

## Следующие шаги

### Если требуются изменения

Не беспокойтесь, многие PR, особенно первые PR, требуют исправления или обновления. Если вы использовали интерфейс GitHub для создания своего PR, вам нужно будет закрыть свой PR, создать новую ветку и повторно отправить. Это связано с тем, что вы не можете раздавить свои коммиты через интерфейс GitHub.

Если у вас есть локальная копия репо, вы можете внести необходимые изменения и внести поправки в свой коммит: `git commit --amend` Это обновит вашу существующую фиксацию. Когда вы нажимаете его на свою вилку, вам нужно будет сделать силовой удар, чтобы перезаписать старый фиксатор: `git push --force`

Обязательно опубликуйте в PR-сообщении, что вы внесли требуемые изменения.

### Если ваш PR принят

Как только ваш PR будет принят, вы можете удалить ветвь, созданную для ее отправки. Это позволяет вашей рабочей вилке очистить. Вы можете сделать это нажатием кнопки на PR-интерфейсе GitHub. Вы можете удалить локальную копию ветки с помощью: `git branch -D branch/to-delete-name`

### Если ваш PR отклонен

Не отчаивайтесь! Вы должны получать надежную обратную связь от модераторов проблемы относительно того, почему она была отклонена и что необходимо. Пожалуйста, продолжайте участвовать.
