---
title: How to Pick a Linux Distribution and Install
localeTitle: Как выбрать дистрибутив Linux и установить
---
В то время как большинство поставщиков предоставляют одну ОС, которая со временем получает инкрементные обновления и новые версии (например, Windows, Mac OSX, Solaris), Linux имеет сотни различных версий, которые можно выбрать из разных поставщиков. Это отчасти потому, что Linux - свободно распространяемый код, который может быть адаптирован к потребностям конкретного пользователя. В то время как [ядро Linux](https://en.wikipedia.org/wiki/Linux_kernel) обычно остается таким же (основная функциональность задач обработки ОС, таких как управление сетью, использование диска, использование памяти, ввод-вывод и т. Д.), Различные версии Linux различаются по частям, например, к используемому графическому интерфейсу (т. [Gnome](https://www.gnome.org/) , [KDE](https://www.kde.org/) , [XFCE](http://www.xfce.org/) или вообще нет), системные инструменты, среды, менеджеры пакетов и приложения. Эта уникальная коллекция программного обеспечения вместе с ядром определяет то, что мы называем [дистрибутивом Linux](https://en.wikipedia.org/wiki/Linux_distribution) (дистрибутив для краткости).

Мнения, по которым распределение на выбор варьируется между пользователями, но лучше выбрать тот, который имеет бесшовную процедуру установки, и регулярно обновляется с исправлениями об ошибках и ошибках. Эти основные дистрибутивы Linux, такие как [Ubuntu](http://www.ubuntu.com/) , [Mint](https://www.linuxmint.com/) и [Fedora](https://getfedora.org/) , охвачены. Все они имеют большую поддержку и большую коллекцию доступного программного обеспечения для бесплатного использования. Еще один вопрос, который следует рассмотреть, это поддержка языков, некоторые дистрибутивы имеют лучшую поддержку на определенных языках, чем другие. Например, [OpenSUSE](https://en.opensuse.org/Main_Page) имеет сильную поддержку немецкого языка, а [Ubuntu Kylin](http://www.ubuntu.com/desktop/ubuntu-kylin) является подрывной деятельностью Ubuntu, которая больше подходит для китайских пользователей с использованием упрощенного китайского языка. Проверьте [DistroWatch](http://distrowatch.com/search.php) для поиска поддержки на других языках.

В большинстве версий Linux есть функция, позволяющая пользователю протестировать дистрибутив, прежде чем устанавливать его на диск в так называемом [live CD](https://en.wikipedia.org/wiki/Live_CD) или в [реальном времени](http://www.linuxliveusb.com/) . Пользователь может поместить меньшую версию дистрибутива, записанную на CD / DVD или USB-накопитель, и загрузиться с нее. Он оставит текущую ОС пользователя неповрежденной, но они могут свободно экспериментировать с пользовательским интерфейсом и некоторыми приложениями. Большинство дистрибутивов предоставят возможность использовать живые медиа для тестирования, а позже при использовании живых медиа предоставляется возможность постоянно устанавливать ОС на диск.

Для пользователей, желающих сохранить свою текущую ОС или не желая совершить полный переход, еще один вариант - создать виртуальную среду и установить в нее Linux с помощью такого инструмента, как [VirtualBox](https://www.virtualbox.org/wiki/Downloads) . Пользователь может запускать свою текущую ОС и иметь окно VirtualBox, работающее с дистрибутивом Linux. Это было бы идеальной ситуацией для тех, кто хочет работать под управлением Windows или OSX, но все же имеет доступ к среде Linux.