---
title: How to Squash Multiple Commits into One with Git
localeTitle: Как сквоить несколько коммитов в одном с Git
---
Это потрясающая функция `rebase` которая может использоваться в `interactive` режиме. Чтобы сквот последнего _n_ фиксируется в одном, выполните следующую команду:
```
git rebase -i HEAD~n 
```

Это откроет текстовый редактор с чем-то похожим на следующее:
```
pick commit_1 
 pick commit_2 
 pick commit_3 
 ... 
 pick commit_n 
 # Bunch of comments 
```

Оставьте первую фиксацию в одиночку и измените оставшуюся часть `pick` на `squash` . Сохраните и выйдите из редактора.

Поэтому, если вы хотите раздавить последние три коммита, сначала запустите `git rebase -i HEAD~3` а затем вы захотите отредактировать свои фиксации, чтобы выглядеть примерно так:
```
pick dd661ba Commit 1 
 squash 71f5fee Commit 2 
 squash f4b4bf1 Commit 3 
```

Если вы уже нажали на удаленный компьютер, прежде чем раздавить свои коммиты, вам придется снова нажать на пульт с флагом `-f` , иначе git вызовет у вас ошибку.

Настоятельно рекомендуется прочитать информацию в открывшемся файле, поскольку есть много вещей, которые вы можете сделать.