---
title: How to Use Git Rebase
localeTitle: Как использовать Git Rebase
---
**Вы ссылались на эту страницу, чтобы принять ваш PR? Прокрутите направо до Git Rebase в FCC!**

`git rebase` - чрезвычайно полезный инструмент, который связан с переписыванием git-истории, хотя чаще всего используется для _раздачи_ нескольких коммитов в один. Хотя это полезно в этом случае, это не единственная функция, которую может выполнять команда `git rebase` . Фактически это оказывается гораздо более полезным при использовании для предполагаемой функции, которую предлагает его название: существенно _перестроить_ ветвь. Позвольте мне объяснить, что я имею в виду.

Скажем, у вас есть репозиторий, например:
```
                                                  --- Commit 5 ----------- auth branch 
                                                / 
                                               --- Commit 4 -------------- dev branch 
                                             / 
 --- Commit 1 ---- Commit 2 ---- Commit 3 -------------------------------- master branch 
```

Если вы хотите объединить ветвь `auth` веткой `dev` , git выдает вам ошибку, потому что ваша ветка `auth` устарела: она не учитывает Commit 4. Вам нужно будет довести ваш филиал вверх- на свидание.

Git предоставляет вам два метода для этого: команду `merge` и команду `rebase` . Для изучения команды `merge` посетите соответствующую статью wiki: [Git Merge](//forum.freecodecamp.com/t/understand-how-to-use-git-merge/13215)

Теперь `rebase` :
```
$ git checkout auth 
 $ git rebase dev 
```

Теперь репо будет выглядеть так:
```
                                                                 --- Commit 5 --- auth branch 
                                                               / 
                                               --- Commit 4 --------------------- dev branch 
                                             / 
 --- Commit 1 ---- Commit 2 ---- Commit 3 --------------------------------------- master branch 
```

Вы видите, что произошло? Git по существу сохранил коммиты в ветке `auth` , «удалил» его, а затем снова создал с теми же фиксациями _после_ коммитов в ветви `dev` . Это означает, что `Commit 4` существует только в ветви `dev` а не в ветке `auth` ! И это действительно все! Сначала это может показаться немного запутанным, но попытайтесь понять диаграмму. Это чрезвычайно полезный инструмент.

## Git-Rebase в FCC

### Предотвращение конфликтов слияния

Если вы вносите вклад в кодовую базу FCC или планируете это делать, всегда запускайте эту команду, прежде чем вносить какие-либо изменения в свои локальные файлы и нажимайте их:

`git pull --rebase upstream staging`

Если у вас нет `upstream` настроения, запустите эту команду, прежде чем запускать указанную выше команду (git выдает ошибку, потому что она не знает, что происходит вверху): `git remote add upstream https://github.com/freecodecamp/freecodecamp.git`

Это приведет к последним изменениям в филиале FCC и переустановке их с помощью промежуточной ветви fork, чтобы у вас не было конфликтов при открытии PR ![:slight_smile:](//forum.freecodecamp.com/images/emoji/emoji_one/slight_smile.png?v=2 ": Slight_smile:")

### давя

Если у вас есть несколько коммитов, которые вы хотите раздавить в один, следуйте инструкциям для **[Squashing](//forum.freecodecamp.com/t/how-to-squash-multiple-commits-into-one-with-git/13231)** .