---
title: Identify Basic Internet Problems with Ping
localeTitle: Определите основные проблемы с Интернетом с помощью Ping
---
![Экран сонара](//discourse-user-assets.s3.amazonaws.com/original/2X/b/b1bfc671722851eed4adfe2d4ec24eb9ab8a875b.png)

В следующий раз, когда вы позвоните в свою справочную службу, вы хотите научиться их знаниям в сети? Используя команду «ping», встроенную прямо в ваш существующий компьютер Mac, Windows или Linux, поможет определить основные проблемы с подключением. Ладно, этого может быть недостаточно, чтобы «вау» ваших товарищей по команде, однако они оценят, что вы начали процесс отладки. И, пожалуйста, помните, что ваши сотрудники службы поддержки являются специалистами-отладочными специалистами, поэтому следуйте их инструкциям, когда они проведут вас через последовательность поиска неисправностей.

## TL; DR:

Вы можете использовать команду `ping` встроенную в компьютер Mac OS X, Windows или Linux, для определения основных проблем с подключением к сети. Это может помочь вам решить проблему и / или получить ценную отладочную информацию в качестве первого шага перед вызовом поддержки. Ниже приведена подробная информация о том, как запустить окно командной строки и запустить `ping` с компьютера Mac OS X или Windows.

## Команда `ping` :

Команда `ping` - это простой способ проверить, что другой компьютер может получать от вас информацию. Оригинальный автор, [Майк Мусс](https://en.wikipedia.org/wiki/Mike_Muuss) , на самом деле [назвал программу после «пингового» звука,](https://en.wikipedia.org/wiki/Ping_%28networking_utility%29#History) который подводная лодка отправляет для обнаружения объектов в воде. Если эхо пинга возвращается, это означает, что есть что-то там. Фактически, `ping` использует « [запрос эхо-сигнала протокола управления Интернетом](https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol) » как часть своего базового программного обеспечения.

В своей простейшей форме команда `ping` предоставляет две ценные части информации, независимо от того, было ли это сообщение возвращено назад ( `64 bytes from…` ) и сколько времени требуется для получения сообщения (например, `time=6.396 ms` ). В зависимости от того, какой тип компьютера вы используете, вы можете получить сводку, содержащую минимум, максимум, средний и т. Д. Время отклика отображается в ms или миллисекундах, которое составляет 1/1000 секунды. Время отклика 10 мс или менее довольно быстро, однако значения часто находятся в диапазоне 100 мс. При значительно более 200 мс вы, вероятно, заметите, что у вас вялое соединение.

## Когда все будет хорошо:

Это то, что мой ответ `ping` выглядит на моем компьютере Mac OS X, когда все работает нормально здесь, в Малайзии:
```
MacBook-Pro:~ ajm$ ping Google.com 
 PING google.com (216.58.196.46): 56 data bytes 
 64 bytes from 216.58.196.46: icmp\_seq=0 ttl=55 time=6.396 ms 
 64 bytes from 216.58.196.46: icmp\_seq=1 ttl=55 time=6.368 ms 
 64 bytes from 216.58.196.46: icmp\_seq=2 ttl=55 time=26.773 ms 
 64 bytes from 216.58.196.46: icmp\_seq=3 ttl=55 time=6.984 ms 
 ^C 
 --- google.com ping statistics --- 
 4 packets transmitted, 4 packets received, 0.0% packet loss 
 round-trip min/avg/max/stddev = 6.368/11.630/26.773/8.746 ms 
```

Это то, что мой ответ `ping` выглядит на компьютере под управлением Windows, когда все работает хорошо:
```
C:\Users\BJM>ping Google.com 
 Pinging google.com [216.58.196.46] with 32 bytes of data: 
 Reply from 216.58.196.46: bytes=32 time=6ms TTL=128 
 Reply from 216.58.196.46: bytes=32 time=15ms TTL=128 
 Reply from 216.58.196.46: bytes=32 time=6ms TTL=128 
 Reply from 216.58.196.46: bytes=32 time=6ms TTL=128 
 Ping statistics for 216.58.196.46: 
    Packets: Sent = 4, Received = 4, Lost = 0 (0% loss), 
 Approximate round trip times in milli-seconds: 
    Minimum = 6ms, Maximum = 15ms, Average = 8ms 
```

Вы можете видеть из этих примеров, что соединение довольно хорошо со средним временем отклика менее 10 мс.

### Когда что-то не так (три примера):

Итак, что произойдет, если я не смогу подключиться к `Google.com` ? Например, \# 1 , я смоделировал разбитое сетевое подключение к моему Mac, отключив мой маршрутизатор от стены и перезапустив команду. Первое, что я замечаю, это то, что команде требуется _много_ времени:
```
MacBook-Pro:~ ajm$ ping google.com 
 ping: cannot resolve google.com: Unknown host 
 MacBook-Pro:~ ajm$ 
```

Или, например, №2 , в зависимости от того, как происходит соединение:
```
PING google.com (216.58.196.46): 56 data bytes 
 Request timeout for icmp\_seq 0 
 Request timeout for icmp\_seq 1 
 Request timeout for icmp\_seq 2 
 ^C 
```

И иногда, если у меня есть особенно щекотливое соединение, я увижу смесь этих сообщений. Например, № 3 , я смогу имитировать это, подключив компьютер Mac к общедоступному Wi-Fi-соединению, расположенному через улицу:
```
PING google.com (216.58.196.206): 56 data bytes 
 64 bytes from 216.58.196.206: icmp\_seq=0 ttl=57 time=273.655 ms 
 64 bytes from 216.58.196.206: icmp\_seq=1 ttl=57 time=808.546 ms 
 64 bytes from 216.58.196.206: icmp\_seq=2 ttl=57 time=179.613 ms 
 Request timeout for icmp\_seq 3 
 Request timeout for icmp\_seq 4 
 64 bytes from 216.58.196.206: icmp\_seq=5 ttl=57 time=374.612 ms 
 Request timeout for icmp\_seq 6 
 ping: sendto: No route to host 
 Request timeout for icmp\_seq 7 
 ping: sendto: No route to host 
 Request timeout for icmp\_seq 8 
 ^C 
```

В первом тесте `ping` сказал мне, что моя машина не может даже найти интернет-адрес (IP `216.58.196.46` ) для `Google.com` . Во втором тесте мой компьютер помнил IP-адрес Google, но фактически не мог дойти до серверов Google (время `Request timeout` ). В третьем тесте `sendto: No route to host` означает, что сетевое устройство знает, где находятся серверы Google, но что-то по цифровому пути нарушено.

## Пользователи Mac: как запустить команду `ping` :

На Mac вы обычно запускаете `ping` из командной строки терминала. Чтобы запустить терминал, щелкните значок увеличительного стекла Spotlight OS X в правом верхнем углу рабочего стола:

![Mac Spotlight](//discourse-user-assets.s3.amazonaws.com/original/2X/9/924e9346b5f92fe41127f6b3e403f454773edae9.png)

Когда появится окно поиска, введите «терминал», выделите «Terminal - Utilities» и дважды щелкните (или нажмите

вернуть

): ![Запуск Mac Terminal](//discourse-user-assets.s3.amazonaws.com/original/2X/9/976e1fb628c0d0bf2a6a9b57504305fd844716d4.png)

Это запустит окно командной строки терминала, и вы можете ввести команду `ping Google.com` показанную в моих примерах: ![Командная строка Mac](//discourse-user-assets.s3.amazonaws.com/original/2X/0/05d1e4d360c14921f7bd7ab871358b956f1e7d03.png)

**Важная подсказка для Mac** : команда `ping` будет работать вечно, если вы не скажете, чтобы она остановилась. Для этого нажмите

`control`

(справа внизу на клавиатуре) и

`c`

ключ. Это прервет проверку с помощью Control-C ( `^C` ) и вернет управление командной строкой. Для пользователя Windows команда останавливается сама по себе после нескольких итераций.

## Пользователи Windows: как запустить команду `ping` :

Открытие командной строки отличается между версиями Windows 10, 8.1, 8 и 7; вот отличный справочник о том, [как открыть командную строку](http://pcsupport.about.com/od/commandlinereference/f/open-command-prompt.htm) . Например, на машине под управлением Windows 7 нажмите на иконку «Пуск» слева внизу и выберите «Командная строка» и дважды щелкните (или нажмите

`enter`

):

![Запуск Win Terminal](//discourse-user-assets.s3.amazonaws.com/original/2X/4/4e0b18755930ad0d64e6e38763f0b96054fd76fb.png)

Это запустит окно команд, и вы можете ввести команду `ping Google.com` показанную в примерах:

![Win Command Line](//discourse-user-assets.s3.amazonaws.com/original/2X/9/94d8ed91d29574497ad0f2eb2cd235050132851e.png)

Теперь, когда вы знаете, как использовать команду `ping` , вы можете выполнить базовое устранение неполадок сетевого подключения. С небольшим количеством творчества вы можете работать со своим местным специалистом по ИТ-поддержке или знать топологию вашей сети и IP-адрес (например, `ping` router, `ping` вашего интернет-провайдера) для дальнейшей идентификации сетевых проблем.