---
title: Installing Django in Virtual Environment
localeTitle: Установка Django в виртуальной среде
---
[Django](https://www.djangoproject.com) - это продуманная структура, которая помогает вам стать продуктивной. Например, файловая структура при создании проекта Django. Но, если вы хотите подробно изучить область веб-разработки в Python; возможно, [Флакс](http://flask.pocoo.org/) больше в вашем переулке. Не стесняйтесь пропустить эту часть статьи и сразу перейдите к [справочной](#installing-flask-in-virtual-environment) системе [Flask](#installing-flask-in-virtual-environment)

На момент написания этой статьи текущей версией Django был Django 1.9.2. Но когда вы читаете это, прямо сейчас, это может быть выше.

Официальное руководство по установке доступно [здесь](https://docs.djangoproject.com/en/1.9/intro/install/#install-django) . Вы должны установить последнюю стабильную и официальную версию; и **не** последняя версия разработки (если вы не знаете, что делаете, и вам нравится жить опасно!)

Но прежде чем приступать к установке, убедитесь, что вы находитесь в **активированной** виртуальной среде; где выполнение следующей команды в терминале будет выглядеть так:
```
$ python --version 
 Python 3.5.1 
```

Для вас это может быть не `3.5.1` . Это вполне может быть `3.4.3` . Но это нормально, пока он не показывает его как `2.7.9` или что-то еще, которое начинается с `2` .

Как только вы убедитесь, что находитесь в активированной виртуальной среде, а команда `python` указывает на Python версии 3; вы готовы установить Django. Просто следуйте официальному [руководству по установке](https://docs.djangoproject.com/en/1.9/topics/install/#installing-official-release) и установите его с помощью `pip` , менеджера пакетов Python.

После установки; было бы неплохо проверить, что все установили `pip` ; выполнив следующую команду:
```
$ pip freeze 
```

Это выведет список модулей, установленных с текущим Python; и вы должны увидеть Django с правильной версией (что-то вроде `Django==1.9.2` в списке.

Если вы хотите использовать Windows, приведенное выше обсуждение не применимо к вам. Возможно, у вас есть только доступ к машине с Windows, и по каким-то личным причинам вы предпочтете не работать в браузере на базе Linux в облаке (возможно, медленное соединение?).

Возможно, вы сможете следовать этому [руководству](https://docs.djangoproject.com/en/1.9/howto/windows/) и настроить Django на Python 3 на вашем компьютере с Windows.

Или вы можете использовать [Virtualbox](https://www.virtualbox.org/) с коробкой [Vagrant](https://www.vagrantup.com/) для разработки Django прямо на вашей машине!