---
title: Installing Flask in Virtual Environment
localeTitle: Установка фляги в виртуальную среду
---
Если вы хотите использовать Flask, вы находитесь в нужном месте! Но установите Flask, только потому, что вы хотите изучить веб-разработку в Flask. Мы всегда рекомендуем Django над Flask, потому что сложно создавать большие веб-приложения в Flask; если вы новичок в веб-разработке в Python.

Колба представляет собой микроструктуру; и вы можете выбрать функциональные возможности, которые вы хотите иметь над базовыми функциями barebone, которые у вас уже есть, от стандартной веб-структуры. Но если вы не хотите делать все хлопот и сосредоточиться на построении своей идеи; возможно, Django станет лучшей компанией на пути вперед.

Я предполагаю, что вы **не** пропустили раздел по установке Python 3 и использовали его в виртуальной среде.

Сначала убедитесь, что вы уже не находитесь в виртуальной среде. Затем создайте новую виртуальную среду под названием `py3-flask`
```
$ mkvirtualenv py3-flask --python=/usr/bin/python3 
```

Теперь запустите команду `workon` чтобы просмотреть список виртуальных сред на вашем компьютере. Это должно `py3-flask` в строке.

После этого активируйте эту среду:
```
$ workon py3-flask 
```

Ваша виртуальная среда будет активирована с помощью копии интерпретатора Python с свойствами Python 3. Вы должны бежать
```
$ python --version 
```

чтобы убедиться, что вы действительно находитесь в среде Python 3.

Чтобы быть ясным, если вы уже установили Django в соответствии с предыдущим разделом, это **не** должно быть в этой среде. Мы используем виртуальную среду; чтобы наша установка различных рамок была разделена.

Безусловно, запустите
```
pip freeze 
```

Убедитесь, что Django не указан в списке вывода, сгенерированном указанной выше командой.

Теперь давайте установим Flask. Для вашего ознакомления, вот [официальное руководство по установке](http://flask.pocoo.org/docs/0.10/installation/) . Тем не менее, многие разработчики предпочитают устанавливать некоторые дополнительные пакеты с помощью Flask; для большей функциональности.

Чтобы установить только флажок, выполните
```
$ pip install flask 
```

Когда вы снова запустите `pip freeze` , он должен показать вам `Flask` в перечисленных пакетах.

Это громоздкое выполнение длинных команд, подобных этому. К счастью, в домене Python есть что-то вроде `package.json` - список зависимостей, которые менеджер пакетов может использовать для дублирования среды, загружая их с соответствующей версией из центрального репо.

Стандарт заключается в том, чтобы использовать `pip freeze` и регистрировать вывод в локальном файле, который может контролироваться источником.
```
$ pip freeze > requirements.txt 
```

Вот содержимое `requirements.txt` из моей среды, после установки этих пакетов Flask. Вы можете добавлять или удалять больше пакетов по мере роста вашего приложения; но на данный момент просто скопируйте содержимое следующего из текстового файла в том же каталоге, в котором вы находитесь.
```
Babel==2.2.0 
 Flask==0.10.1 
 Flask-Babel==0.9 
 Flask-Login==0.3.2 
 Flask-Mail==0.9.1 
 Flask-OpenID==1.2.5 
 Flask-SQLAlchemy==2.1 
 Flask-WTF==0.12 
 Flask-WhooshAlchemy==0.56 
 Jinja2==2.8 
 MarkupSafe==0.23 
 SQLAlchemy==1.0.12 
 Tempita==0.5.2 
 WTForms==2.1 
 Werkzeug==0.11.4 
 Whoosh==2.7.2 
 blinker==1.4 
 coverage==4.0.3 
 decorator==4.0.9 
 defusedxml==0.4.1 
 flipflop==1.0 
 guess-language==0.2 
 itsdangerous==0.24 
 pbr==1.8.1 
 python3-openid==3.0.9 
 pytz==2015.7 
 six==1.10.0 
 speaklater==1.3 
 sqlalchemy-migrate==0.10.0 
 sqlparse==0.1.18 
```

Этот список пакетов взят [отсюда](http://blog.miguelgrinberg.com/post/the-flask-mega-tutorial-part-i-hello-world) .

Как только вы сохранили файл, просто запустите
```
$ pip install -r requirements.txt 
```

Менеджер пакетов позаботится об установке отсутствующих пакетов для вас! И вы должны зафиксировать этот файл с помощью вашей системы управления версиями.

Вышеупомянутый набор команд предполагает, что у вас есть машина Linux или Mac OSX; или вы используете облачную панель на cloud9 или Nitrous; или, может быть, вы используете коробку бродяг.

Но если вам нужно использовать Windows-компьютер, подумайте об использовании Windows Powershell вместо Windows CMD. Большинство команд будут одинаковыми. Если вам нужна помощь, вы можете проверить [это обсуждение переполнения стека](http://stackoverflow.com/questions/17917254/how-to-install-flask-on-windows) .