---
title: Interview Questions for Junior Front End Web Developers
localeTitle: Интервью для младших веб-разработчиков
---
Цель этой статьи - ознакомить свежих веб-разработчиков Front-End с вопросами по учебнику. Если вы просто попадаете в мир разработчиков, есть хорошие шансы, что вы будете нервничать при опросе для позитива разработчика. Из-за этого некоторые относительно основные вопросы могут чувствовать себя более сложными, чем то, как они на самом деле. Хороший счетчик для этого сценария должен быть надлежащим образом подготовлен.

## Вопросов

Без дальнейших церемоний, вот несколько вопросов, которые вы могли бы встретить:

### HTML / CSS

1.  В контексте стилизации CSS вы можете объяснить, что означает `display-style: inline-block` ?
2.  Если у вас есть элемент `<ul>` с несколькими элементами `<li>` , как бы вы решили настроить эти элементы в строке с помощью HTML и CSS?
3.  В стилях CSS, когда вы будете использовать `float` s? Как они работают?
4.  Когда вы будете использовать: `clear: both;` ?
5.  Что такое Bootstrap? Когда вы его используете? Как работает его сетка?
6.  Объясните понятие отзывчивого дизайна и как оно работает? Используйте пример, если хотите.
7.  Что такое DOM? Что ты об этом знаешь?
8.  Что такое SASS? В чем преимущества его использования?

### JavaScript

1.  Что такое ECMAScript?
2.  Что такое jQuery и для чего он обычно используется?
3.  В чем разница между `==` и `===` в JS?
4.  Можете ли вы перечислить все типы данных JavaScript?
5.  Что такое функция обратного вызова в JS и когда вы ее используете?
6.  В чем разница между `undefined` и `null` ?
7.  Что такое асинхронный ответ?
8.  Что означает JSON? Для чего его используют?
9.  Как вы объясните запрос API?
10.  С какими API вы работали?
11.  Как бы вы отправили / конвертировали в формат JSON?
12.  В чем разница между `GET` и `POST` при указании запроса AJAX?

### Программное обеспечение / Инструменты

1.  Вы работали с Photoshop в качестве разработчика интерфейса? Для чего?
2.  Какую систему управления версиями программного обеспечения вы использовали? Не могли бы вы описать, как будет выглядеть рабочий процесс в этой системе?

### О вас

1.  Какой был самый сложный проект, над которым вы когда-либо работали? Почему это было сложно? Если это приложение / алгоритм, вы можете объяснить, как это работает?
2.  Как вы можете быть в курсе новостей о технологиях?
3.  На каких побочных проектах вы работали?
4.  Существуют ли какие-либо языки или рамки, которые вы хотели бы узнать в будущем? Как бы вы учились? Почему вы выбрали эти языки / рамки?
5.  Каковы наиболее важные навыки и качества, которые должен иметь младший разработчик интерфейса?