---
title: Keep Data in Sync in Angular
localeTitle: Хранить данные в синхронизации в угловых
---
Предположим, что вы хотите, чтобы что-то появилось в представлении пользователя, когда вы добавляете его в базу данных. Новая _вещь_ , объект будет мгновенно отображаться в цикле _нг-повторов_ в вашей точки зрения HTML , если вы просто добавить его в свой локальный массив с
```
$scope.awesomeThings.push(newThing); 
```

Но вам все равно нужно добавить его в свою коллекцию баз данных. Добавьте его в свою коллекцию с помощью
```
$http.post('/api/things', newThing); 
```

Но ждать! Вы скоро поймете , что в то время как все другие вещи в вашем массиве _$ scope.awesomeThings_ имеют уникальные идентификаторы , назначенные MongoDB (под _вещи._ Id\_ недвижимость), ваш _newThing_ объект не будет, что сделает его трудно для вас в какой - то момент к сделать действия с базой данных на нем (удаление его из вашей базы данных требует использования его свойства _._ id\_). Итак, что вы хотите сделать после добавления в свой массив _$ scope.awesomeThings_ (потому что мы хотим, чтобы он сразу отображался на странице пользователя). В целом, ваш код для добавления newThing в ваш локальный массив и базу данных будет выглядеть так:
```
$scope.awesomeThings.push(newThing); 
 $http.post('/api/things', newThing).success(function(thatThingWeJustAdded) { 
    $scope.awesomeThings.pop(); // let's lose that id-lacking newThing 
    $scope.awesomeThings.push(thatThingWeJustAdded); // and add the id-having newThing! 
 }; 
```

Это обновляет локальный массив для кажущихся мгновенными результатами для вашего пользователя, а затем синхронизирует его с вашей базой данных и обновляет локальный массив в фоновом режиме с помощью базы данных вашего _нового_ объекта _Thing_ , уникального _._ id\_ и все. Обратите внимание на обратный вызов , мы переходим к функции _успеха_ получает новую _вещь_ обратно из базы данных в качестве аргумента! Таким образом, вы можете легко добавить его обратно в локальную область без лишних издержек.