---
title: Known Issues with Codepen
localeTitle: Известные проблемы с Codepen
---
Учащимся Free Code Camp рекомендуется использовать [Codepen.io](http://www.codepen.io/) для составления проектов, а Codepen - это фантастический ресурс для быстрого создания полезного кода. Однако Codepen вводит дополнительный уровень абстракции в процесс отладки кода. Вот некоторые известные проблемы, которые могут вас тронуть в Codepen, если вы не знаете о них:

1.  **Проблема URL с** привязными **тегами:** CodePen переопределяет `<a href='URL'>` элементы привязки, что означает, что вам нужно добавить `target='_blank'` к вашим элементам привязки - иначе они не будут работать.
2.  **Проблема с подключением https.** Расширение Chrome «HTTPS Everywhere» (созданное [Electronic Frontiers Foundation](http://www.eff.org/) ), как известно, мешает вызовам AJAX. Поскольку расширение автоматически использует HTTPS, оно может вызвать ошибку «смешанного содержимого», которая предотвращает загрузку данных JSON / XML. Если вы столкнулись с такой ошибкой, убедитесь, что ваши плагины не являются виновниками. При желании вы можете использовать [crossorigin.me](http://crossorigin.me) в качестве прокси.
3.  **imgur hotlinking:** Если вы используете изображения с **сайта** [http://imgur.com,](http://imgur.com) они не будут отображаться большую часть времени, это связано с их TOS. Способ решения этой проблемы - использовать альтернативный сервис, например [http://postimg.org](http://postimg.org)
4.  **auto reload:** по умолчанию каждый раз, когда вы вносите изменения в окна редактора HTML или JS, окно предварительного просмотра обновляется. Вы можете отключить эту функцию и включить «кнопку запуска», перейдя в «Настройки»> «Поведение»> «Хотите кнопку« Выполнить »? и освободить коробку.
5.  **location.reload:** если вы столкнулись с проблемой своего кода, работающего в режиме отладки или в JSFiddle, но не в представлении редактора Codepen или полном просмотре страницы, проверьте, используется ли `location.reload()` . Если вы это сделали, вам нужно найти другой способ добиться желаемого, потому что Codepen разделит `location.reload` и оставит только `()` в вашем коде. Подробнее [здесь:](https://blog.codepen.io/documentation/editor/things-we-strip/)
6.  **отображать изображения, добавлять файлы css / js, размещенные в GitHub:** вы можете захотеть включить в свою таблицу стилей проекта, образ или файл js, размещенный в GitHub. Если вы добавите ссылку GitHub вашего файла в свои настройки в Codepen или в свой html / css, он не будет работать из коробки. Что вам нужно сделать:
    1.  Перейдите в версию «Raw» файла
    2.  Скопируйте URL-адрес
    3.  Изменить `raw.githubusercontent.com` на `rawgit.com`
    4.  используйте этот URL для ссылки на файлы, размещенные на github
