---
title: Learn How to Plan Your Future Project
localeTitle: Узнайте, как планировать свой будущий проект
---
Унция приготовления стоит фунта лечения. Это верно в медицине, и это определенно верно в разработке программного обеспечения.

Вот структурированный 10-шаговый рабочий процесс, который поможет вам в процессе планирования приложений, с целью избавить вас от написания большого количества ненужного кода.

Вместе мы планируем простое одноточечное веб-приложение «Делать». Мы также планируем использовать API-интерфейс для будущего мобильного приложения.

## 1) Создайте нашу доску Trello

[Trello](https://trello.com/) - это забавный, свободный способ разбить процесс планирования и разработки на небольшие задачи, которые можно отслеживать.

![Изображение платы Trello](https://lh3.googleusercontent.com/EI4AQ4NINm3B2DHR_YIS29JyKVa5dTPiT3RtITylmndFlpshTHepsKuO8_1KQNfdPDSBjslDReHCuPFeH1GNrDtgOwTyq6ZtGf3DFBmq1AsAhPHKt_0pLXQLf0o4ZbDuKVj4-Bo)

[Вот что будет выглядеть в наши дни совет Trello](https://trello.com/b/O9MZcYyY/todo-app) . Я предпочитаю разбивать свои задачи на 3 столбца (в зависимости от сложности проекта):

*   Делать - то, что нужно делать
*   В процессе - задачи, которые в настоящее время работают люди
*   Выполнено - задачи, которые выполняются и готовы к тестированию

## 2) Пишите истории пользователей

Вот несколько примеров пользовательских историй. Они расскажут о том, как мы относимся к функциям и функциям нашего приложения. Обратите внимание, что все они следуют аналогичной структуре: как [человек\] Я могу \[сделать что-то\].](https://lh5.googleusercontent.com/2v6iIMbCrLSKVfqttEToum7OA3YGQCBKWUHcSCB1KEbEcijXxQtKJKY6fhLXeecJiO27P4icOuPlkVc9_uNXolzlzNXOo_TPh09GZsAqRH-JISqPrpx0PZdtbHOr0RIuQUbTbaw)

*   как зарегистрированный пользователь, я могу видеть список моих дел.
*   как зарегистрированный пользователь, я могу добавить новое занятие.
*   как зарегистрированный пользователь, я могу удалить занятие (только мои дела - не другие пользователи).
*   как зарегистрированный пользователь, я могу завершить работу (только для моих пользователей - не для других пользователей).
*   как анонимный пользователь, я могу зарегистрироваться для новой учетной записи, восстановить пароль или войти в приложение с существующей учетной записью.

## 3) Создайте нашу модель использования

Наша модель использования поможет нам визуализировать наши истории пользователей, чтобы мы могли лучше понять, как их реализовать.

! \[Анонимная диаграмма случая пользователя

![Диаграмма сценария аутентифицированного пользователя](https://lh6.googleusercontent.com/3V6dVvAcyjqFkaOukimucYOX0CfwBBYNN9SvjmnVy40Pdhs4Wtrr34i3E-9pbV7tFsp4jHm77IFQvFupjq6OWyxqEgCzcQ995Ayh52Msczu6TfwKeNhL9PYHyxSgmPYA1TR6l6Q)

## 4) Создайте нашу диаграмму деятельности

Наша диаграмма активности покажет разные пути, которые наши пользователи могут принять через наше приложение.

![Изображение диаграммы операций](https://lh6.googleusercontent.com/jAQL4myqWOPA3gk2iTpGyAQBrO6p1GlPe8BQQ1Se6a-Di40X3Zw1p0wfJewZUL-YyDmedYzX5Lxvo2GW2Qnr6I-6kuKe1sDb9_5F_n46cKoawWReWW_ZoZCIJO6Semc4fvsiuHc)

Пользователь обращается к нашему деловому приложению.

*   Если пользователь не войдет в систему, она увидит нашу страницу входа.
    
*   Если у нее уже есть учетная запись, она может войти в систему.
    
*   Если у нее есть учетная запись, но она забыла пароль, она может восстановить свой пароль.
    
*   Если у нее нет учетной записи, она может ее создать.
    
*   И «создать учетную запись», и «восстановить мой пароль» потребует проверки по электронной почте. Пользователь может войти в наше приложение только после подтверждения ее адреса электронной почты.
    
*   Если она войдет в систему, она увидит ее список дел (это может быть пустым, если она еще не добавила никаких досок).
    
*   Зарегистрированный пользователь:
    
    *   может видеть список своих задач
        
    *   может отметить задачу из своего списка как завершенную
        
    *   может выполнять поиск в своем списке задач
        
    *   может удалить задачу из своего списка
        
    *   может выйти из системы.
        
*   Пользователь может выйти из приложения в любое время.
    

## 5) Создайте наши макеты

Наши макеты показывают, как должно выглядеть наше приложение. Гораздо быстрее перебирать макет, чем это делается на рабочем коде.

![Макетная фотография](https://lh3.googleusercontent.com/GBFhmBkfr-xM5YSXlR0Fm9y8b24ivdRlUtRWQOHJ8skNxEgjTkAef0e5nZ-CcHKNUq2p4V4hgDuAm9LSEuvbovlVborH1ZioAUXVlEblWZ4hN_d2tGEpxhfTkKH9os2JS1pab4w)

## 6) Выберите подходящие технологии для нашего проекта

Поскольку это одностраничное приложение, мы будем полагаться в значительной степени - или в этом случае исключительно - на JavaScript. Давайте используем один из самых популярных стеков JavaScript: стек MEAN. Одним из больших преимуществ стека MEAN является то, что все его компоненты являются свободными и с открытым исходным кодом. Существует также множество ресурсов, доступных для изучения стека MEAN, и для его отладки, когда вы неизбежно сталкиваетесь с ошибками.

Вы можете создать [среду разработки стека MEAN](http://www.freecodecamp.com/challenges/get-set-for-our-back-end-development-projects) и запустить ее в облаке менее чем за час бесплатно.

Вот компоненты, которые мы будем использовать:

1.  [MongoDB](http://mongodb.org/) для нашей базы данных
2.  [Node.js](http://nodejs.org/) и [Express.js](http://expressjs.com/) для реализации нашего API
3.  [AngularJS](http://angularjs.org/) , наряду с HTML и CSS (и Bootstrap) для нашего клиентского приложения
4.  [Mongoose](http://mongoosejs.com/) для подключения нашего приложения к MongoDB

## 7) Разработка нашей схемы базы данных

Это стоит усилий для разработки схемы базы данных, даже для нашего простого приложения.

У нас будет две коллекции: в нашей коллекции «Пользователи» будут размещаться наши пользовательские данные, и наша коллекция «ToDo» будет содержать наши задачи, которые необходимо выполнить. Один пользователь может иметь нулевые, одно или многие задачи в своем списке дел, поэтому у нас будет соотношение «один ко многим» (1: m) между двумя нашими коллекциями.

![Схема схемы базы данных](https://lh6.googleusercontent.com/5uSb_xnSSc5CWXJD0yyUGVJsL92RRZl3Bex_3wjuzl5Xr69Ks0j3od-yFju24SAd5wWMBNy9uqBrvOzdrUWluOkbcr4H5zFg-ZemJX3ZRWS12D42OowuvWnxA7wWIGrhhzaQ0aw)

## 8) Определите наши варианты использования

1.  Что происходит с to-dos, связанным с пользователем, который удаляет ее учетную запись? Когда пользователь удаляет свою учетную запись, to-dos, связанный с этим пользователем, также должен быть удален.
2.  Нет необходимости делать это без привязки к подтвержденному пользователю.
3.  Хозяин может быть удален только его владельцем.
4.  Пользователь не может быть добавлен с пустым именем пользователя или паролем.
5.  Нечего делать с пустой задачей.

Что нужно помнить:

1.  Используйте промежуточное программное обеспечение Mongoose для удаления зависимых документов, таких как dos, когда пользователь удаляет свою учетную запись.
2.  Используйте правила проверки Mongoose для моделей, чтобы предотвратить добавление пустых полей в нашу базу данных.

## 9) Разработка и тестирование нашего API

Я использовал бесплатный продукт под названием Apiary [для документирования нашего API](http://docs.fcctodoapp.apiary.io/) .

Вот синтаксис, который я использовал для [создания этого простого BluePrint](https://jsapi.apiary.io/apis/fcctodoapp.apib) .

Я рекомендую вам создать учетную запись и начать играть с ней. Если вы связываете свою [учетную](http://github.com/) запись [GitHub](http://github.com/) с Apiary, вы можете убедиться, что ваша документация всегда остается актуальной. Вы также сможете проверить свои данные визуально, не нажимая на конечные точки API. Если вы предпочитаете тестировать свой API из командной строки, [вот пример того, как это сделать](http://docs.agendor.apiary.io/) .

Позже, после того, как вы внедрили свой API с помощью Node.js и Express.js, вам просто нужно установить свой URL в Apiary. Затем вы можете начать тестирование своих звонков. Наш текущий URL-адрес хоста ( [http://fcctodoapp.apiblueprint.org/](http://fcctodoapp.apiblueprint.org/) ) будет заменен URL вашего API.

![Демо-версия приложения](https://lh6.googleusercontent.com/hU3ilG_y9FqtL_zajQ_KOjWy8Qx590Go8nkNvA1j0oR50YJTpjJhL1lAPgjyeLTAS06tq6V62EcJrLQyT_TR2BK49DYiX6kksU6s9cqJDvvaS6jvepIM6uiO4JMbXuu-oXhdsas)

## 10) Начните писать код!

Это интересная часть, и это займет большую часть времени вашего проекта. Если вам нужна помощь в этом, присоединяйтесь к нам и научитесь кодировать.