---
title: Make Useful APIs in Angularjs
localeTitle: Сделать полезный APIs в Angularjs
---
Однако еще две вещи, которые вы должны сделать, прежде чем это будет полезно для вас. Предположим, вы хотите показать все, _что_ связано с именем пользователя, запрошенным на этой странице: сначала вы должны

1.  Есть «имя пользователя» или поле «Владелец» в вашей схеме _вещи_ в `/server/api/thing/thing.model.js`
    
2.  Напишите пользовательский маршрут в `/server/api/thing/index.js` чтобы поймать запрос для определенного имени пользователя. Запрос от вашего интерфейса может выглядеть примерно так:
    
    $ http.get ('/ api / things /' + имя пользователя) .success (...)
    

поэтому вы добавите строку в свой `index.js` например:
```
router.get('/:user', controller.indexUser); 
```

а затем в `thing.controller.js` вы напишете функцию _exports.indexUser_ вот так:
```
exports.indexUser = function(req, res) { 
    Thing.find({owner:req.params.user}, function (err, things) { 
        if(err) return res.send(500, err); 
        res.json(200, things); 
    }); 
 }; 
```

Предупреждение!!! этот метод работает только в том случае, если имена пользователей абсолютно уникальны между пользователями. Система аутентификации по умолчанию, которая поставляется с генератором углового ползуна, не имеет уникальных имен пользователей, поэтому вам, вероятно, лучше использовать _пользователя._ id\_ для определения уникальных пользователей в вашей базе данных, если вы не хотите самостоятельно внедрять уникальные имена пользователей, изменяя ваши `/api/user/user.model.js` , `/api/user/user.controller.js` и ваше `/app/client/account/signup/signup.controller.js` . К счастью, вы должны знать, как это сделать после прочтения этого руководства!