---
title: Markdown Code Formatting
localeTitle: Форматирование кода Markdown
---
# Форматирование кода Markdown

Существует два способа форматирования кода в Markdown. Вы можете использовать встроенный код, помещая обратные элементы вокруг частей строки, или вы можете использовать блок кода, который некоторые рендереры будут применять для выделения синтаксиса.

## Встроенный код

Вы можете использовать форматирование встроенного кода, чтобы подчеркнуть небольшую команду или часть синтаксиса в строке, которую вы пишете.

Например, вы можете упомянуть `Array.protoype.map()` Javascript. Используя форматирование встроенного кода, ясно, что это фрагмент кода. Вы также можете использовать его для иллюстрации команды терминала, например, для `yarn install` .

Чтобы использовать форматирование встроенного кода, просто оберните код, который вы хотите отформатировать в обратном направлении. На стандартной клавиатуре QWERTY, расположенной в США, это можно найти слева от «1» и над Tab. Ниже приведена дополнительная информация о местоположении обратного хода на международных клавиатурах.

Например, запись \`Array.prototype.map ()\` в `Array.prototype.map()` уценки будет отображаться как `Array.prototype.map()` .

## Блоки кода

Чтобы писать более длинные или более подробные фрагменты кода, часто лучше разместить их внутри блока кода. Блоки кода позволяют использовать несколько строк, а уценка будет отображать их внутри своего окна и шрифтом типа кода.

Для этого запустите свой блок с помощью строки из трех backticks. Это сигнализирует о том, что вы создаете блок кода. Вам нужно будет закончить с другой линией из трех backticks. Например:

\`\` \`

var add2 = function (number) {

номер возврата + 2;

}

\`\` \`

будет отображать в уценке как:
```
var add2 = function(number) { 
    return number + 2; 
 } 
```

Несмотря на то, что уценка не поддерживается по умолчанию, многие механизмы разметки, в том числе используемые GitHub, будут поддерживать подсветку синтаксиса. Это означает, что, указав уценку, какой язык мы используем внутри нашего блока, он добавит цвета, такие как IDE. Вы можете сделать это, добавив название языка в той же строке, что и три раза назад. В приведенном выше примере, если вместо первой строки \`\` \`мы используем\` \`\` js, то выделение будет применено к нашему блоку.

```js
var add2 = function(number) { 
    return number + 2; 
 } 
```

Однако это может быть применено не только к javascript. Я могу использовать \`\` \`html:

```html

<div class="row"> 
    <div class="col-md-6 col-md-offset-3"> 
        <h1>Hello World</h1> 
    </div> 
 </div> 
```

\`\` \`Рубин:

```ruby
"Hello World".split('').each do |letter| 
    puts letter 
 end 
```

или \`\` \`python:

```python
a, b = 0, 1 
 while b < 10: 
    print(b) 
    a, b = a, a + b 
```

плюс многие другие. Но помните, что не все механизмы разметки будут применять подсветку синтаксиса.

## Впечатывание Backticks

Расположение клавиши backtick может отличаться на разных клавиатурах, и если вы не используете клавиатуру QWERTY в США, это может быть сложно найти. [В этом](http://superuser.com/a/254077/122424) полезном руководстве перечислены некоторые способы поиска вашего обратного ключа, который мы собрали здесь ниже.

#### QWERTY и QWERTZ (Ключ, отмеченный красной рамкой)

![QWERTY](//discourse-user-assets.s3.amazonaws.com/optimized/2X/a/a7daf1d707e12e207d47f0eb70ba01d97ffd1924_1_690x327.png)

#### AZERTY France ( Alt Gr + Key, отмеченный красной рамкой)

![AZERTY](//discourse-user-assets.s3.amazonaws.com/original/2X/8/8f65c339ce4eefd9d79841f3dc54f4c37cab2e77.png)

#### АЗЕРБАЙДЖАН Бельгия ( Alt Gr + Key, отмеченный красной рамкой)

![введите описание изображения здесь](//discourse-user-assets.s3.amazonaws.com/original/2X/d/de291f0895b0fed992726a62d654f4e1f0e421f3.png)

#### QWERTY Estonian (Ключи, отмеченные красной рамкой)

![Раскладка эстонской клавиатуры](//discourse-user-assets.s3.amazonaws.com/optimized/2X/0/089b26510b1dcc7553625ba162582cf55837b6cd_1_690x230.png)

### Код Alt

Наконец, ключ backtick имеет код alt, который должен работать на любом ключевом слове. Если вы не можете найти кнопку обратной линии на клавиатуре, вы можете удерживать клавишу Alt и нажимать 9, затем 6 (Alt + 9, 6). Это добавит обратную сторону.