---
title: MaterializeCSS Framework as an Alternative to Bootstrap
localeTitle: MaterializeCSS Framework как альтернатива Bootstrap
---
[MaterializeCSS](http://materializecss.com/) - это современная адаптивная интерфейсная платформа, основанная на [принципах материального дизайна](https://www.google.com/design/spec/material-design/introduction.html) Google.

## Что такое материальный дизайн?

Дизайн материалов (под кодовым названием Quantum Paper) - это система проектирования, разработанная компанией Google. Расширяясь по мотивам «карты», которые дебютировали в Google Now, Material Design делает более либеральным использование макетов на основе сетки, гибких анимаций и переходов, дополнений и глубинных эффектов, таких как освещение и тени.

Это [видео](https://www.youtube.com/watch?v=Q8TXgCzxEnw) дает вам представление о материальном дизайне:

## Просмотрите эти веб-сайты, которые используют Materialize, и посмотрите на отличие от того, к чему вы привыкли!

Протестируйте их на своем телефоне, чтобы лучше почувствовать.

*   [100](https://www.100xp.io/)
    
*   [Темы администрирования](http://demo.geekslabs.com/materialize/v2.1/)
    
*   [StrapHq](http://www.straphq.com/)
    

Другие примеры [здесь](http://materializecss.com/showcase.html)

## Альтернатива Bootstrap, действительно?

Чилл, на мой взгляд, ничто не может победить Бутстрап. Однако материализуйте CSS, предлагая именно это, Materialize-ation - ощущение взаимодействия с интерфейсом, как будто это физический материал, такой как бумага. Я просто придумал это.

Но действительно…

Мне нравится материализоваться из-за его простоты, например:

В Bootstrap вы сделаете это, чтобы создать кнопку
```
<button class="btn btn-primary btn-lg"> 
 My Button 
 </button> 
```

В основном каждое имя класса неоднократно привязано к нему btn. И это в основном относится ко многим другим компонентам начальной загрузки, особенно если вы хотите добавить простые классы, такие как цвет.

С помощью Materialize вы можете добавить все классы просто так:
```
<button class="btn waves-effect waves-light green">My Button</a> 
```

Как вы можете видеть, использование btn- было уменьшено. `green` класс можно повторно использовать с любым / всем другим элементом HTML, кроме `button` показанной в этом случае.

Существует еще одна более легкая версия Material Design Framework, но она не такая элегантная или простая, как материализующая среда CSS. Помимо этой простоты, здесь есть еще больше причин, почему я люблю материализациюCSS:

*   Это просто! - Просто подчеркивая
*   Это с открытым исходным кодом, вы можете это сделать здесь
*   Сообщество также растет вокруг него
*   [Кто-то](http://fezvrasta.github.io/bootstrap-material-design/) хочет создать смесь Bootstrap + Materialize. Sweeet!

## Что-нибудь еще?

Попробуйте, и, возможно, вам понравится. Фактически, с тех пор, когда уже настроен пользовательский интерфейс Android, это может стать хорошим способом улучшить качество дизайна материалов для мобильных веб-приложений, таких как [прогрессивные веб-приложения](https://developers.google.com/web/fundamentals/getting-started/your-first-progressive-web-app/#what-will-you-learn)

### Может быть, вы не должны его использовать ... пока

Он подвергается изменениям на альфа-стадии. Поэтому вы можете пропустить его и не использовать его в критическом проекте, пока он не созреет.