---
title: Npm Behind a Proxy Server
localeTitle: Npm за прокси-сервером
---
## Случаи применения

Возможно, вам потребуется изменить команды `npm install` которые обращаются к удаленным репозиториям ( [например](https://www.npmjs.com/) , [npmjs](https://www.npmjs.com/) ) для установки модулей Node JS; если ваш интернет-доступ через [прокси-сервер](https://en.wikipedia.org/wiki/Proxy_server) .

Прокси-серверы распространены в среде колледжей и бизнес-типов.

Вы можете [найти свои настройки прокси](http://www.wikihow.com/Change-Proxy-Settings) на панели [настроек](http://www.wikihow.com/Change-Proxy-Settings) вашего браузера.

## Использование прокси с NPM

После того, как вы получили настройки прокси-сервера (URL-адрес сервера, порт, имя пользователя и пароль); вам необходимо настроить конфигурацию `npm` следующим образом.
```
$ npm config set proxy http://<username>:<password>@<proxy-server-url>:<port> 
 $ npm config set https-proxy http://<username>:<password>@<proxy-server-url>:<port> 
```

Вам нужно будет заменить `<username>` , `<password>` , `<proxy-server-url>` , `<port>` значениями, специфичными для ваших учетных данных прокси-сервера.

Эти поля являются необязательными. Например, ваш прокси-сервер может даже не требовать `<username>` и `<password>` , или что он может работать на порту 80 (в этом случае `<port>` не требуется).

Как только вы их установили, ваша `npm install` , `npm i -g` и т. Д. `npm i -g` работать правильно.

## Когда не использовать

Вам не нужно использовать команды `npm` с настройками прокси-сервера, если происходит одно из следующих событий:

> *   Например, системный администратор или корпоративная политика не позволяет вам обращаться к удаленным репозиториям `npm` из NPM-JS.
> *   Удаленный репозиторий модулей узла находится не в вашей машине, но находится во внутренней сети.

## Отменить настройки прокси-сервера

Используйте [это](http://luxiyalu.com/how-to-remove-all-npm-proxy-settings/) сообщение в блоге, чтобы отключить настройки прокси-сервера. Вы также можете вручную удалить строки, определяющие настройки прокси-сервера, из вашего [файла](https://docs.npmjs.com/files/npmrc) `.npmrc` .

## Ресурсы

Вы можете использовать следующие ресурсы для дальнейшего чтения:

> *   [Могу ли я войти в прокси-сервер](https://github.com/npm/npm/issues/9401#issuecomment-134569585)
> *   [NPM за корпоративным прокси](http://intenseagile.com/2015/09/04/npm-behind-proxy.html)