---
title: Override Local Files with Git Pull
localeTitle: Переопределение локальных файлов с помощью Git Pull
---
# Когда вам нужно перезаписать локальные файлы?

Если вы чувствуете необходимость отбросить все свои локальные изменения и просто перезагрузите или перезапишите все с помощью копии из удаленной ветви, вы должны следовать этому руководству.

Важно: если у вас есть локальные изменения, они будут потеряны. С помощью или без опции, любые локальные фиксации, которые не были `--hard` , будут потеряны.  
Если у вас есть файлы, которые не отслеживаются Git (например, загруженный контент пользователя), эти файлы не будут затронуты.

## Рабочий процесс Overwrite:

Чтобы перезаписать локальные файлы, выполните следующие действия:
```
git fetch --all 
 git reset --hard <remote>/<branch_name> 
```

Например:
```
git fetch --all 
 git reset --hard origin/master 
```

## Как это работает:

`git fetch` загружает последние данные с удаленного устройства, не пытаясь объединить или переустановить что-либо.

Затем сброс git сбрасывает ведущую ветвь на то, что вы только что выбрали. Опция `--hard` изменяет все файлы в рабочем дереве в соответствии с файлами в `--hard` `origin/master` файле.

## Дополнительная информация:

Стоит отметить, что можно поддерживать текущие локальные коммиты, создавая ветку от `master` или любой ветки, с которой вы хотите работать до сброса:

Например:
```
git checkout master 
 git branch new-branch-to-save-current-commits 
 git fetch --all 
 git reset --hard origin/master 
```

После этого все старые коммиты будут храниться в транзакциях `new-branch-to-save-current-commits` . Однако незавершенные изменения (даже поставленные) будут потеряны. Удостоверьтесь в том, чтобы прикрыть и совершить все, что вам нужно.

## Attribution:

_Эта статья основана на вопросе переполнения стека [здесь](http://stackoverflow.com/questions/1125968/force-git-to-overwrite-local-files-on-pull/8888015#8888015)_