---
title: Pseudoclassical Class Definition
localeTitle: Определение псевдоклассического класса
---
Определение псевдоклассического класса происходит в 2 блоках кода вместо одного, что происходит на других языках, таких как Python и PHP.

Первый блок называется «конструкторской функцией», в которой объявляются атрибуты класса. Это аспекты класса, которые уникальны для каждого нового экземпляра. Пример с автомобилями заключается в том, что бренд, цвет и местоположение могут отличаться. Во втором блоке кода вы объявляете методы, которые будут использоваться каждым экземпляром класса. Примеры - это то, что может сделать автомобиль, двигаться вперед, останавливаться, открывать дверь.

## пример
```
var Car = function(brand, color, location) { 
 this.brand = brand; 
 this.color = color; 
 this.location = location 
 }; 
 
 Car.prototype = { 
 move: function() { this.location++; }, 
 stop: function() { this.location = 0; }, 
 }; 
```

## объяснение

Причиной объявления всего класса в 2-х блоках является сохранение в памяти при запуске создания экземпляров класса. Если объявление класса было «Функциональным» стилем, то есть новая копия метода (ов), созданного для **каждого** экземпляра. Объявляя класс «псевдоклассический» стиль, только _одна_ копия методов хранится в памяти.

Когда экземпляр класса попытается получить доступ к методу:
```
var x_car = new Car('lexus', 'white', 0); 
 x_car.move(); 
```

Переводчик будет на самом деле _первый_ не найти вызываемый метод в самом объекте , так как это было сделано из конструктора функции автомобиля. Как вы можете видеть выше, нет ссылки на какой-либо из методов в функции конструктора Car. Оттуда интерпретатор ищет `Car.prototype` который теперь разделяется между всеми экземплярами. Там переводчик находит метод, который был вызван!

### Дальнейшее чтение:

[Блог пользователя Natac](https://natacseanc.wordpress.com/2015/08/04/javascript-object-create-and-classes/)

[Классы MDN](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Introduction_to_Object-Oriented_JavaScript)